/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.ui.image;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.j3d.ui.CapturedImageObserver;

public class JPEGSequenceObserver
implements CapturedImageObserver {
    private boolean enabled = false;
    private String filename;
    private File directory;
    private int sequenceNumber;

    public void setFileDetails(String string, String string2) {
        if (this.enabled) {
            throw new IllegalStateException("Currently capturing images");
        }
        if (string == null) {
            throw new IllegalArgumentException("Directory reference is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("fileBase is null");
        }
        this.directory = new File(string);
        this.directory.mkdirs();
        this.filename = string2;
        this.sequenceNumber = 0;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void canvasImageCaptured(BufferedImage bufferedImage) {
        if (!this.enabled) {
            return;
        }
        if (this.filename == null) {
            throw new IllegalStateException("The filename is not set");
        }
        try {
            File file = new File(this.directory, this.filename + this.sequenceNumber + ".jpg");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(0.9f, false);
            jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
            jPEGImageEncoder.encode(bufferedImage);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("I/O exception writing JPEG image! " + iOException);
            iOException.printStackTrace();
        }
        ++this.sequenceNumber;
    }
}

