/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import spec.jbb.JBButil;
import spec.reporter.JBBReportFilenameFilter;
import spec.reporter.Metrics;
import spec.reporter.ReportProps;
import spec.reporter.TableGroupCompare;
import spec.reporter.Template;
import spec.reporter.Title;

public class MultiVMReport {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 2005 Hewlett-Packard,All rights reserved,Copyright (c) 1997-2005 Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";
    private static String logo = "<IMG SRC=\"spec-sm.gif\" WIDTH=\"57\" HEIGHT=\"72\"\nALT=\"[SPEC logo]\" ALIGN=MIDDLE>";
    private static final String version = "@(#)Report.java\t1.18 08/03/98";
    public String hardware;
    public String name;
    public String software;
    public boolean SPECInternalUse;
    public String issue;
    public boolean echoRaw;
    public String prefix;
    public String labelImg;
    public String metric1;
    public String metric2;
    public String[] graphTable;
    public String[] metric;
    public Metrics[] metrics;
    public ReportProps[] results;
    public File[] htmlFiles;
    public Template template;
    public ReportProps titles = new ReportProps();
    public boolean useHtml;
    public String[] label;
    public String output_directory;
    public int instances = 0;
    public boolean instanceChecksPassed = true;

    public MultiVMReport(String string, boolean bl, String string2, boolean bl2, boolean bl3) {
        this(string, bl, string2, bl2, bl3, "000", "SPECjbb.");
    }

    public MultiVMReport(String string, boolean bl, String string2, boolean bl2, boolean bl3, String string3, String string4) {
        this.SPECInternalUse = bl;
        this.issue = string2;
        this.output_directory = string;
        this.labelImg = string3;
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("Error: file " + string + " doesn't exist.");
            System.exit(1);
        }
        if (!file.isDirectory()) {
            System.out.println("Error: file " + string + " is not a directory.");
            System.exit(1);
        }
        String string5 = ".raw";
        JBBReportFilenameFilter jBBReportFilenameFilter = new JBBReportFilenameFilter(string4, string5);
        File[] fileArray = file.listFiles(jBBReportFilenameFilter);
        this.instances = fileArray.length;
        string5 = ".html";
        jBBReportFilenameFilter = new JBBReportFilenameFilter(string4, string5);
        this.htmlFiles = file.listFiles(jBBReportFilenameFilter);
        this.results = new ReportProps[fileArray.length];
        this.metrics = new Metrics[fileArray.length];
        this.graphTable = new String[fileArray.length];
        this.metric = new String[fileArray.length];
        this.label = new String[fileArray.length];
        try {
            StringReader stringReader = new StringReader(new Title().getTitleString());
            this.titles.load(stringReader);
        }
        catch (IOException iOException) {
            JBButil.getLog().log(Level.WARNING, "Error loading titles for report\n", iOException);
            System.exit(1);
        }
        double d = 0.0;
        long l = 0L;
        long l2 = 0L;
        boolean bl4 = true;
        for (int i = 0; i < fileArray.length; ++i) {
            this.results[i] = new ReportProps();
            this.label[i] = fileArray[i].getName().substring(string4.length(), string4.length() + 3);
            if (bl) {
                this.label[i] = string4 + this.label[i];
            }
            try {
                this.results[i].load(fileArray[i].getPath());
            }
            catch (IOException iOException) {
                JBButil.getLog().log(Level.WARNING, "Error reading results file " + fileArray[i] + ": " + iOException, iOException);
                System.exit(1);
            }
            this.metrics[i] = new Metrics(this.results[i], bl);
            this.graphTable[i] = this.metrics[i].tableAndGraph(this.label[i], bl2, string);
            this.metric[i] = this.metrics[i].metric();
            try {
                d += Double.parseDouble(this.metric[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                bl4 = false;
                this.metric1 = "n/a";
                this.metric2 = "n/a";
            }
        }
        this.checkInstanceTiming();
        if (bl4) {
            this.metric1 = Metrics.format(d);
            this.metric2 = Metrics.format(d / (double)this.metrics.length);
        }
        this.name = this.results[0].get("input.suite");
        this.hardware = this.results[0].get("config.hw.vendor") + " " + this.results[0].get("config.hw.model");
        this.software = this.results[0].get("config.sw.vendor") + " " + this.results[0].get("config.sw.JVM");
        this.generateSingleRawFile();
    }

    public void checkInstanceTiming() {
        int n;
        int n2 = 0;
        int n3 = 0;
        this.instanceChecksPassed = true;
        long l = 0L;
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MAX_VALUE;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        n2 = this.metrics[0].getWarehousesTested();
        ++n3;
        for (n = 1; n < this.instances && n2 == this.metrics[n].getWarehousesTested(); ++n) {
            ++n3;
        }
        if (n3 != this.instances) {
            System.out.println("INVALID: Instances do not have identical test counts");
            this.instanceChecksPassed = false;
        } else {
            for (n = 1; n <= n2 && this.instanceChecksPassed; ++n) {
                l = 0L;
                l2 = Long.MAX_VALUE;
                l3 = Long.MAX_VALUE;
                l4 = 0L;
                for (int i = 0; i < this.instances; ++i) {
                    if (n < this.metrics[i].get_whAtPeak()) continue;
                    l7 = this.metrics[i].start_millis_at_wh(n);
                    if (l7 < l2) {
                        l2 = l7;
                    }
                    if ((l8 = this.metrics[i].rampup_millis_at_wh(n)) > l) {
                        l = l8;
                    }
                    if ((l5 = this.metrics[i].rampdown_millis_at_wh(n)) < l3) {
                        l3 = l5;
                    }
                    if ((l6 = this.metrics[i].end_millis_at_wh(n)) <= l4) continue;
                    l4 = l6;
                }
                if (l3 > l4 && l2 > l) {
                    this.instanceChecksPassed = true;
                    continue;
                }
                System.out.println("INVALID MULTI-JVM Run: Test Interval " + n + ": Instance Timing Checks: FAILED");
                System.out.println("(first_rampdown_millis > last_end_millis) && (first_start_millis > last_rampup_millis))");
                System.out.println("first_start_millis    = " + l2);
                System.out.println("last_rampup_millis    = " + l);
                System.out.println("first_rampdown_millis = " + l3);
                System.out.println("last_end_millis       = " + l4);
                this.instanceChecksPassed = false;
            }
        }
    }

    public void print(String string) {
        try {
            this.print(new PrintStream(new BufferedOutputStream(new FileOutputStream(string))));
        }
        catch (IOException iOException) {
            JBButil.getLog().log(Level.WARNING, "Error creating output: " + iOException, iOException);
        }
    }

    public void print(PrintStream printStream) {
        int n;
        boolean bl = true;
        String string = "";
        for (n = 0; n < this.metrics.length; ++n) {
            if (this.metrics[n].valid) continue;
            bl = false;
        }
        if (!this.instanceChecksPassed) {
            bl = false;
            string = "JVM Instance Timing Checks Failed";
        }
        try {
            int n2;
            printStream.println("<HTML><HEAD>\n<META NAME=\"GENERATOR\" CONTENT=\"SPEC Java Reporter\">\n<TITLE> " + this.name + "</TITLE>\n" + "</HEAD>");
            printStream.print("<BODY ");
            if (bl) {
                printStream.print(this.results[0].get("spec.report.bodyAttributes", ""));
            } else {
                this.metrics[0].relocateImageResource("invalid.gif", this.output_directory);
                printStream.print("BACKGROUND=\"invalid.gif\"");
            }
            printStream.print(">\n");
            printStream.print("<TABLE WIDTH=100%>\n<TR><TD COLSPAN=2>");
            if (this.issue != null && !this.issue.equals("")) {
                this.metrics[0].relocateImageResource("spec-sm.gif", this.output_directory);
                printStream.print(logo);
            } else {
                printStream.print("<FONT SIZE=+2></FONT>&nbsp;");
            }
            if (!bl) {
                printStream.print("<FONT SIZE=+2> Invalid Run: </FONT>&nbsp");
            }
            printStream.print("<FONT SIZE=+2>" + this.name + "2005</FONT></TD>\n" + "<TD COLSPAN=2 ALIGN=RIGHT bgcolor=FFFF00>" + "    <FONT SIZE=+2 COLOR=000000><B> bops = " + this.metric1 + ",  bops/JVM = " + this.metric2 + "</B></FONT></TD></TR>\n" + "<TR><TD COLSPAN=3><FONT SIZE=+1>" + this.hardware + "</FONT></TD></TR>\n");
            if (this.software != null) {
                printStream.print("<TR><TD COLSPAN=3><FONT SIZE=+1>" + this.software + "</FONT></TD></TR>\n");
            }
            if (string != "") {
                printStream.print("<TR><TD COLSPAN=3><font size=+2>INVALID because " + string + "</TD><TR>");
            }
            printStream.println("</TABLE>");
            printStream.println("<P> <TABLE WIDTH=100%><TR><TD ALIGN=TOP><CENTER><P><TABLE BORDER=1><TR><TH> JVM run </TH><TH> JVM Scores </TH></TR>");
            for (n = 0; n < this.metrics.length; ++n) {
                printStream.println("<TR><TD>" + (n + 1) + "</TD><TD>" + this.metric[n] + "</TD></TR>");
            }
            printStream.println("<TR><TH COLSPAN=2> bops = " + this.metric1 + ", bops/JVM = " + this.metric2 + "</TABLE></TD><TD>" + Metrics.multiCurvesGraph(this.metrics, this.labelImg, this.SPECInternalUse, this.output_directory) + "</TD></TABLE>");
            printStream.print("<P>\n");
            BufferedReader bufferedReader = new BufferedReader(new StringReader(new Template().getTemplateString()));
            BufferedReader bufferedReader2 = new BufferedReader(new StringReader(new Template().getTemplateString()));
            TableGroupCompare tableGroupCompare = new TableGroupCompare(bufferedReader, bufferedReader2, this.results[0], null, this.titles);
            printStream.println(tableGroupCompare.toString());
            for (n2 = 0; n2 < this.metrics.length; ++n2) {
                printStream.println("<p><p><hr><center><b><font size=+2><a href=" + this.htmlFiles[n2].getName() + "> JVM " + (n2 + 1) + " Scores: </a></font></b></center>");
                printStream.println(this.graphTable[n2]);
                this.testBar(printStream);
            }
            printStream.println("<HR><FONT SIZE=-1>\n");
            printStream.println("SPECjbb2005 Version: [" + this.results[0].get("config.benchmark_version", "N/A") + ", " + this.results[0].get("config.benchmark_versionDate", "-") + "]");
            printStream.println("<BR><I>\n");
            if (this.issue != null && !this.issue.equals("") && bl) {
                printStream.println("Published by SPEC " + this.issue + "<br>");
            }
            printStream.println("Reporting page, Copyright &copy; 2005 SPEC. All rights reserved\n</I></FONT>");
            printStream.println("<!-- ");
            printStream.println("Reporting Page Generator @(#)Report.java\t1.18 08/03/98");
            if (this.echoRaw) {
                for (n2 = 0; n2 < this.results.length; ++n2) {
                    this.results[n2].store(printStream, "Raw Results for " + (n2 + 1) + " JVM");
                }
            }
            printStream.println(" -->");
            printStream.print("</BODY></HTML>\n");
            printStream.close();
        }
        catch (Exception exception) {
            JBButil.getLog().log(Level.WARNING, "Error: " + exception, exception);
        }
    }

    public void testBar(PrintStream printStream) throws IOException {
        String string = this.results[0].get("config.test.specLicense", "MISSING");
        String string2 = this.results[0].get("config.test.testedBy", "MISSING");
        String string3 = this.results[0].get("config.test.date", "MISSING");
        printStream.println("<TABLE WIDTH=\"100%\" BORDER=1 CELLSPACING=2 CELLPADDING=0><tr>\n<td width=33%><b>SPEC license # </b>" + string + "</td>\n" + "<td width=33%><b>Tested by: </b>" + string2 + "</td>\n" + "<td><b>Test date: </b>" + string3 + "</td>\n" + "</tr></TABLE>");
    }

    public void generateSingleRawFile() {
        Object object;
        String string;
        String string2;
        ReportProps reportProps = new ReportProps();
        String string3 = this.output_directory + File.separator + "SPECjbb.raw";
        File file = new File(string3);
        if (file.exists()) {
            file.delete();
        }
        Enumeration<?> enumeration = this.results[0].propertyNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (string2.startsWith("result.")) continue;
            string = this.results[0].get(string2);
            reportProps.put("global." + string2, string);
        }
        for (int i = 0; i < this.results.length; ++i) {
            object = this.results[i].propertyNames();
            while (object.hasMoreElements()) {
                string2 = (String)object.nextElement();
                string = this.results[i].get(string2);
                if (!string2.startsWith("result.")) continue;
                reportProps.put(i + 1 + "." + string2, string);
            }
        }
        try {
            PrintStream printStream = new PrintStream(string3);
            Set<Object> set = reportProps.keySet();
            object = new Vector<Object>(set);
            Collections.sort(object);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                String string4 = (String)((Vector)object).elementAt(i);
                String string5 = reportProps.getProperty(string4);
                printStream.println(string4 + "=" + string5);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JBButil.getLog().log(Level.WARNING, "ERROR: file not found " + string3, fileNotFoundException);
            System.exit(1);
        }
    }
}

