#include "main.ih"

// Room for Args initialization
namespace   // the anonymous namespace can be used here
{
    Arg::LongOption longOptions[] =
    {
                // only interpreted from the command-line

        Arg::LongOption("config",       'c'),
        Arg::LongOption("foreground",   Arg::NoArg),
        Arg::LongOption("help",         'h'),
        Arg::LongOption("list",         'l'),
        Arg::LongOption("reload",       'r'),
        Arg::LongOption("stdout",       's'),
        Arg::LongOption("terminate",    't'),
        Arg::LongOption("version",      'v'),
                                       
                // all options below are also interpreted when specified by
                // the config file

        Arg::LongOption("agent",            Arg::Required),
        Arg::LongOption("log",              'L'),
        Arg::LongOption("mailer",           'm'),
        Arg::LongOption("syslog",           Arg::NoArg),
        Arg::LongOption("syslog-facility",  Arg::Required),
        Arg::LongOption("syslog-priority",  Arg::Required),
        Arg::LongOption("syslog-tag",       Arg::Required),
        Arg::LongOption("uds",              'u'),
        Arg::LongOption("verbose",          'V'),
    };

    auto longEnd = longOptions + size(longOptions);
}

int main(int argc, char **argv)
try
{
    ArgConfig &arg = ArgConfig::initialize("c:hi:lL:m:rstu:vV", 
                        longOptions, longEnd, argc, argv);
    arg.versionHelp(usage, Icmbuild::version, 0);

    SSHCron sshcron;
    sshcron.run();
}
catch (...)
{
    return handle(current_exception());
}
