% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{load_units_xml}
\alias{load_units_xml}
\title{Load a unit system}
\usage{
load_units_xml(path = default_units_xml())
}
\arguments{
\item{path}{a path to a valid unit system in XML format.}
}
\description{
Load an XML database containing a unit system compatible with UDUNITS2.
}
\details{
A unit system comprises a root \code{<unit-system>} and a number of children
defining prefixes (\code{<prefix>}) or units (\code{<unit>}).
See the contents of

\code{system.file("share/udunits", package="units")}

for examples.
}
\examples{
# load a new unit system
load_units_xml(system.file("share/udunits/udunits2-base.xml", package="units"))
\dontrun{
set_units(1, rad) # doesn'twork
}

# reload the default unit system
load_units_xml()
set_units(1, rad) # works again

}
