% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post-favorite.R
\name{post_favorite}
\alias{post_favorite}
\alias{post_favourite}
\alias{favorite_tweet}
\title{Favorites target status id.}
\usage{
post_favorite(
  status_id,
  destroy = FALSE,
  include_entities = FALSE,
  token = NULL
)
}
\arguments{
\item{status_id}{Status id of target tweet.}

\item{destroy}{Logical indicating whether to post (add) or
remove (delete) target tweet as favorite.}

\item{include_entities}{Logical indicating whether to
include entities object in return.}

\item{token}{Expert use only. Use this to override authentication for
a single API call. In most cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}
}
\description{
Favorites target status id.
}
\examples{
if (auth_has_default()) {
   rt <- search_tweets("#rstats", n = 1)
   post_favorite(rt$id_str)
}
}
\references{
Create: \url{https://developer.twitter.com/en/docs/twitter-api/v1/tweets/post-and-engage/api-reference/post-favorites-create}
Destroy: \url{https://developer.twitter.com/en/docs/twitter-api/v1/tweets/post-and-engage/api-reference/post-favorites-destroy}
}
\seealso{
Other post: 
\code{\link{post_follow}()},
\code{\link{post_friendship}()},
\code{\link{post_tweet}()}
}
\concept{post}
