% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_edge_mutual.R
\name{is_edge_mutual}
\alias{is_edge_mutual}
\title{Is the edge mutual with another edge?}
\usage{
is_edge_mutual(graph, edge)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{edge}{A numeric edge ID value.}
}
\value{
A logical value.
}
\description{
Determines whether an edge definition has a mutual analogue with the same
node pair.
}
\examples{
# Create a graph that has mutual
# edges across some node pairs
graph <-
  create_graph() \%>\%
  add_path(n = 4) \%>\%
  add_edge(
    from = 4,
    to = 3) \%>\%
  add_edge(
    from = 2,
    to = 1)

# Get the graph's internal
# edge data frame
graph \%>\% get_edge_df()

# Determine if edge `1` has
# a mutual edge
graph \%>\%
  is_edge_mutual(edge = 1)

# Determine if edge `2` has
# a mutual edge
graph \%>\%
  is_edge_mutual(edge = 2)

}
