% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcmd-bg.R
\name{rcmd_bg}
\alias{rcmd_bg}
\title{Run an \verb{R CMD} command in the background}
\usage{
rcmd_bg(
  cmd,
  cmdargs = character(),
  libpath = .libPaths(),
  stdout = "|",
  stderr = "|",
  poll_connection = TRUE,
  repos = default_repos(),
  system_profile = FALSE,
  user_profile = "project",
  env = rcmd_safe_env(),
  wd = ".",
  supervise = FALSE,
  ...
)
}
\arguments{
\item{cmd}{Command to run. See \code{R --help} from the command
line for the various commands. In the current version of R (3.2.4)
these are: \code{BATCH}, \code{COMPILE}, \code{SHLIB}, \code{INSTALL}, \code{REMOVE}, \code{build},
\code{check}, \code{LINK}, \code{Rprof}, \code{Rdconv}, \code{Rd2pdf}, \code{Rd2txt}, \code{Stangle},
\code{Sweave}, \code{Rdiff}, \code{config}, \code{javareconf}, \code{rtags}.}

\item{cmdargs}{Command line arguments.}

\item{libpath}{The library path.}

\item{stdout}{Optionally a file name to send the standard output to.}

\item{stderr}{Optionally a file name to send the standard error to.
It may be the same as \code{stdout}, in which case standard error is
redirected to standard output. It can also be the special string
\code{"2>&1"}, in which case standard error will be redirected to standard
output.}

\item{poll_connection}{Whether to have a control connection to
the process. This is used to transmit messages from the subprocess
to the parent.}

\item{repos}{The \code{repos} option. If \code{NULL}, then no
\code{repos} option is set. This options is only used if
\code{user_profile} or \code{system_profile} is set \code{FALSE},
as it is set using the system or the user profile.}

\item{system_profile}{Whether to use the system profile file.}

\item{user_profile}{Whether to use the user's profile file.
If this is \code{"project"}, then only the profile from the working
directory is used, but the \code{R_PROFILE_USER} environment variable
and the user level profile are not. See also "Security considerations"
below.}

\item{env}{Environment variables to set for the child process.}

\item{wd}{Working directory to use for running the command. Defaults
to the current working directory.}

\item{supervise}{Whether to register the process with a supervisor. If \code{TRUE},
the supervisor will ensure that the process is killed when the R process
exits.}

\item{...}{Extra arguments are passed to the \link[processx:process]{processx::process}
constructor.}
}
\value{
It returns a \link{process} object.
}
\description{
The child process is started in the background, and the function
return immediately.
}
\section{Security considerations}{


\code{callr} makes a copy of the user's \code{.Renviron} file and potentially of
the local or user \code{.Rprofile}, in the session temporary
directory. Avoid storing sensitive information such as passwords, in
your environment file or your profile, otherwise this information will
get scattered in various files, at least temporarily, until the
subprocess finishes. You can use the keyring package to avoid passwords
in plain files.
}

\seealso{
Other R CMD commands: 
\code{\link{rcmd_copycat}()},
\code{\link{rcmd}()}
}
\concept{R CMD commands}
