% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash64.R
\name{runif64}
\alias{runif64}
\title{integer64: random numbers}
\usage{
runif64(
  n,
  min = lim.integer64()[1L],
  max = lim.integer64()[2L],
  replace = TRUE
)
}
\arguments{
\item{n}{length of return vector}

\item{min}{lower inclusive bound for random numbers}

\item{max}{upper inclusive bound for random numbers}

\item{replace}{set to FALSE for sampleing from a finite pool, see \code{\link[=sample]{sample()}}}
}
\value{
a integer64 vector
}
\description{
Create uniform random 64-bit integers within defined range
}
\details{
For each random integer we call R's internal C interface \code{unif_rand()} twice.
Each call is mapped to 2^32 unsigned integers. The two 32-bit patterns are
concatenated to form the new integer64. This process is repeated until the
result is not a \code{NA_INTEGER64_}.
}
\examples{
  runif64(12)
  runif64(12, -16, 16)
  runif64(12, 0, as.integer64(2^60)-1)  # not 2^60-1 !
  var(runif(1e4))
  var(as.double(runif64(1e4, 0, 2^40))/2^40)  # ~ = 1/12 = .08333

  table(sample(16, replace=FALSE))
  table(runif64(16, 1, 16, replace=FALSE))
  table(sample(16, replace=TRUE))
  table(runif64(16, 1, 16, replace=TRUE))

}
\seealso{
\code{\link[=runif]{runif()}}, \code{\link[=hashfun]{hashfun()}}
}
\keyword{classes}
\keyword{distribution}
\keyword{sysdata}
