% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emb.r
\name{ameliabind}
\alias{ameliabind}
\title{Combine multiple runs of Amelia}
\usage{
ameliabind(...)
}
\arguments{
\item{...}{one or more objects of class \code{amelia} with the same
arguments and created from the same data.}
}
\value{
An object of class \code{amelia}.
}
\description{
Combines multiple runs of \code{amelia} with the same
arguments and data into one \code{amelia} object.
}
\details{
\code{ameliabind} will combine multiple runs of \code{amelia} into one
object so that you can utilize diagnostics and modelling on all the
imputations together. This function is useful for combining multiple
runs of \code{amelia} run on parallel machines.

Note that \code{ameliabind} only checks that they arguments and the
missingness matrix are identical. Thus, it could be fooled by two
datasets that are identical up to a transformation of one variable.
}
\examples{
data(africa)
a1.out <- amelia(x = africa, cs = "country", ts = "year", logs = "gdp_pc")
a2.out <- amelia(x = africa, cs = "country", ts = "year", logs = "gdp_pc")
all.out <- ameliabind(a1.out, a2.out)
summary(all.out)
plot(all.out)

}
\seealso{
\code{\link{amelia}}
}
