\name{paCalls}
\alias{paCalls}
\alias{paCalls,ExonFeatureSet-method}
\alias{paCalls,GeneFeatureSet-method}
\alias{paCalls,ExpressionFeatureSet-method}
\title{Methods for P/A Calls}
\description{
  Methods for Present/Absent Calls are meant to provide
  means of assessing whether or not each of the (PM) intensities are
  compatible with observations generated by background probes.
}
\usage{
paCalls(object, method, ..., verbose=TRUE)
\S4method{paCalls}{ExonFeatureSet}(object, method, verbose = TRUE)
\S4method{paCalls}{GeneFeatureSet}(object, method, verbose = TRUE)
\S4method{paCalls}{ExpressionFeatureSet}(object, method, ..., verbose = TRUE)
}
\arguments{
  \item{object}{Exon/Gene/Expression-FeatureSet object.}
  \item{method}{String defining what method to use. See 'Details'.}
  \item{...}{Additional arguments passed to MAS5. See 'Details'}
  \item{verbose}{Logical flag for verbosity.}
}
\value{
  A matrix (of dimension dim(PM) if method="DABG" or "MAS5"; of dimension
  length(unique(probeNames(object))) x ncol(object) if method="PSDABG")
  with p-values for P/A Calls.
}
\details{
  For Whole Transcript arrays (Exon/Gene) the valid options for
  \code{method} are 'DABG' (p-values for each probe) and 'PSDABG'
  (p-values for each probeset). For Expression arrays, the only option
  currently available for \code{method} is 'MAS5'.
  
  ABOUT MAS5 CALLS:
  
  The additional arguments that can be passed to MAS5 are:
  \enumerate{
    \item \code{alpha1}: a significance threshold in (0, alpha2);
    \item \code{alpha2}: a significance threshold in (alpha1, 0.5);
    \item \code{tau}: a small positive constant;
    \item \code{ignore.saturated}: if TRUE, do the saturation correction described in
    the paper, with a saturation level of 46000;
  }

 This function performs the hypothesis test:

  H0: median(Ri) = tau, corresponding to absence of transcript
  H1: median(Ri) > tau, corresponding to presence of transcript

 where Ri = (PMi - MMi) / (PMi + MMi) for each i a probe-pair in the 
 probe-set represented by data.

 The p-value that is returned estimates the usual quantity:

   Pr(observing a more "present looking" probe-set than data | data is absent)

 So that small p-values imply presence while large ones imply absence of 
 transcript.  The detection call is computed by thresholding the p-value as 
 in:

 call "P" if p-value < alpha1
 call "M" if alpha1 <= p-value < alpha2
 call "A" if alpha2 <= p-value

}

\references{
  Clark et al. Discovery of tissue-specific exons using comprehensive
  human exon microarrays. Genome Biol (2007) vol. 8 (4) pp. R64

  Liu, W. M. and Mei, R. and Di, X. and Ryder, T. B. and Hubbell, E. and Dee,
  S. and Webster, T. A. and Harrington, C. A. and Ho, M. H. and Baid, J. and
  Smeekens, S. P. (2002) Analysis of high density expression microarrays with
  signed-rank call algorithms, Bioinformatics, 18(12), pp. 1593--1599.
  
  Liu, W. and Mei, R. and Bartell, D. M. and Di, X. and Webster, T. A. and
  Ryder, T. (2001) Rank-based algorithms for analysis of microarrays,
  Proceedings of SPIE, Microarrays: Optical Technologies and Informatics, 4266.
  
  Affymetrix (2002) Statistical Algorithms Description Document, Affymetrix
  Inc., Santa Clara, CA, whitepaper.
  \url{http://www.affymetrix.com/support/technical/whitepapers/sadd_whitepaper.pdf}
}

\author{
  Benilton Carvalho
}
\examples{
\dontrun{
if (require(oligoData) & require(pd.huex.1.0.st.v2)){
  data(affyExonFS)
  ## Get only 2 samples for example
  dabgP = paCalls(affyExonFS[, 1:2])
  dabgPS = paCalls(affyExonFS[, 1:2], "PSDABG")
  head(dabgP) ## for probe
  head(dabgPS) ## for probeset
}
}
}
\keyword{manip}
