## Usage

With [snapdragon][] v0.9.0 and higher you can use `this.node()` to create a new `Node`, whenever it makes sense.

```js
var Node = require('{%= name %}');
var Snapdragon = require('snapdragon');
var snapdragon = new Snapdragon();

// example usage inside a parser visitor function
snapdragon.parser.set('foo', function() {
  var pos = this.position();
  // if the regex matches the substring at the current position
  // on `this.input`, return the match
  var match = this.match(/foo/);
  if (match) {
    // if node.type is not defined on the node, the parser
    // will automatically add it
    var node = pos(new Node(match[0]));

    // or, explictly pass a type
    var node = pos(new Node(match[0], 'bar'));
    // or
    var node = pos(new Node({type: 'bar', val: match[0]}));
    return node;
  }
});
```

## API
{%= apidocs("index.js") %}
