/*
 * Copyright (C) by Argonne National Laboratory
 *     See COPYRIGHT in top-level directory
 */

#include "mpidimpl.h"

int MPIDI_CH3_PktHandler_Revoke(MPIDI_VC_t *vc, MPIDI_CH3_Pkt_t *pkt,
                                void *data ATTRIBUTE((unused)),
                                intptr_t *buflen, MPIR_Request **rreqp)
{
    MPIDI_CH3_Pkt_revoke_t *revoke_pkt = &pkt->revoke;
    int mpi_errno = MPI_SUCCESS;
    MPIR_Comm *comm_ptr = NULL;

    MPL_DBG_MSG_D(MPIDI_CH3_DBG_OTHER, VERBOSE, "Received revoke pkt from %d", vc->pg_rank);

    /* Search through all of the communicators to find the right context_id */
    MPIDI_CH3I_Comm_find(revoke_pkt->revoked_context_id, &comm_ptr);
    if (comm_ptr == NULL)
        MPIR_ERR_SETANDJUMP1(mpi_errno, MPI_ERR_OTHER, "**ch3|postrecv",
                "**ch3|postrecv %s", "MPIDI_CH3_PKT_REVOKE");

    mpi_errno = MPID_Comm_revoke(comm_ptr, 1);
    if (mpi_errno != MPI_SUCCESS)
        MPIR_ERR_SETANDJUMP1(mpi_errno, MPI_ERR_OTHER, "**ch3|postrecv",
                "**ch3|postrecv %s", "MPIDI_CH3_PKT_REVOKE");

    /* There is no request associated with a revoke packet */
    *rreqp = NULL;

fn_fail:
    return mpi_errno;
}
