// Copyright 2019-2022, Collabora, Ltd.
// SPDX-License-Identifier: BSL-1.0
/*!
 * @file
 * @brief  USB Serial interface for OpenGloves.
 * @author Daniel Willmott <web@dan-w.com>
 * @ingroup drv_opengloves
 */

#pragma once
#include <stdint.h>
#include <stddef.h>

#include "../opengloves_communication.h"

#ifdef __cplusplus
extern "C" {
#endif

struct opengloves_serial_device
{
	struct opengloves_communication_device base;
	int fd;
};

int
opengloves_serial_open(const char *path, struct opengloves_communication_device **out_comm_dev);

#ifdef __cplusplus
}
#endif
