/* ----- decode/857xint32, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_857xint32_checksums[] = {
  "f1cce1fb5860ff77e49eb8f6c96947a8a1f779fde85a87809410317bf9e39a20",
  "bfff4d5b75d91994c2dc064236468c4fd59fd4df7d08d7b8b52dbf95c9891a91",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_857xint32_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_857xint32_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_857xint32_ITEMBYTES

static void *storage_decode_857xint32_x;
static unsigned char *test_decode_857xint32_x;
static void *storage_decode_857xint32_s;
static unsigned char *test_decode_857xint32_s;
static void *storage_decode_857xint32_x2;
static unsigned char *test_decode_857xint32_x2;
static void *storage_decode_857xint32_s2;
static unsigned char *test_decode_857xint32_s2;

#define precomputed_decode_857xint32_NUM 4

static const uint32_t precomputed_decode_857xint32_x[precomputed_decode_857xint32_NUM][crypto_decode_ITEMS] = {
  {1940977188,1740126204,953838538,4022503884,3090166535,579058073,1991150592,3355051151,2457718373,1507203356,2700210720,2327665748,4059676708,3323395045,3947653796,1070603031,3196008902,2061512069,3442320467,2901604430,709566259,763920141,2998037509,3848079294,4239065531,498620458,1855771773,170993204,795653177,2252290014,2214891152,2066417491,1931703811,3848407642,1831884975,963534915,3372588300,3306852645,2078375479,130251791,3500822423,2813650623,3200256740,787298180,880186369,1309067898,444809964,3112593951,3260363777,425162201,1895749749,2945337588,3636116465,2490553363,3073008219,1590475368,1182129387,2850943997,3296239682,812068655,889674496,1578130705,454127356,4213996509,2623470008,3786500539,2277815166,3239623732,1668462351,2689817769,1225394393,1050429316,457063828,1245913780,571418586,3471004112,3779296680,4001184057,2259197723,2421889914,2566743536,3234775165,2607289654,1425316101,1447646951,3907676370,3188353839,1126216842,328283185,3231981606,2767969593,3124029300,2915076931,2207988097,1807107813,418323296,1811389497,1329582090,1789192136,2613736391,2548558630,524028810,1717052611,3096164367,2868429102,2370790606,220091462,2426807270,2242537784,1537548828,497881758,260608478,227542358,3454516449,1236245325,936810082,2100153261,609268469,4143203525,3039856831,3071290046,1513451709,492754778,3835421741,134077944,1420516194,1658300158,1861102861,3271287261,2807364545,2312071991,3391247199,3432855536,4027358233,118692488,109505415,27743672,2249905530,1633124846,4110209708,4053102468,4258599566,3016828084,2027596996,1692709306,838892409,473985773,77300386,3674523906,3322315822,397930484,3854694320,2892483182,3291780114,1004525726,2511682287,582386159,2532990006,1188649138,2654463393,2752896253,1790364705,1245903252,2360314084,1552963006,1756586311,923960563,189453091,2070210819,2964490065,2351276701,2189379631,105781048,3833406250,3845335680,2299330552,1290154481,3679337196,3762226671,1973639203,499563392,2817289897,829046299,2365475994,2639238790,3637552949,3443495690,3186909396,933821367,3957172866,1187844805,3971904469,972036909,3358852997,1609984956,2385426892,4124086047,377991083,857595245,424665310,955852071,2405404443,603335976,2215801051,991488908,2224070803,3710597422,1417036015,633959993,3597928159,2975883339,1386509086,3989642690,537738277,2436041939,706101295,36092968,2724809155,653673509,2531437668,1736903202,2533266361,2142593269,1025299698,2920882583,250117818,1125099835,2222079410,4068691342,1832418240,1231897642,3075916099,2215745621,1658336972,2631908130,3539632910,2835471336,3475628703,843069390,991389707,90841386,1766493068,227603309,1811200782,3073953063,1723089245,3238111616,3901063345,1149642279,2682314943,1661256015,3471365707,1061888521,1898877096,4281237178,240210836,1863323928,956461510,2263243859,413464875,1525951288,705849210,2826969473,2994649286,3144594535,3163746284,2442510767,3711283032,3994854144,1649373586,782701811,1672156665,2903395907,1955395096,3386042848,3795813718,632074859,3549691373,90116173,1953889885,819852538,1178306104,3397060572,3042207743,1557345020,966380398,97767285,2763917324,837678285,2025415124,2300092626,3088632962,4148650452,3690752646,573897061,743848357,2079311044,2386155859,2155029155,2461953145,2800540965,1812667714,215158819,1461444310,4035751740,725679089,3383575592,4281690165,891754424,159269871,1040488993,445936190,118777459,4028985043,1502253731,3382329750,1661855798,733347251,2380243264,2470202703,439529591,4266348100,2299829937,3002939982,1619189227,3568055012,4205749194,367753549,1149083698,3465331969,890478733,2880121595,1303698736,2704423307,4241371416,3939850380,3269678531,1857309647,1874204988,2231054,251975157,3775699173,3668006196,2355373286,1626312691,1167737314,4064064589,212729765,1597855120,4114423108,3803898797,2212625115,3869891154,1811077382,4115280651,2925995743,3766899593,1620579685,2892748394,3729371722,2113441879,3963288342,433297780,2794129711,88736065,1428727240,2064690900,2050749844,4092213966,3262959771,834065845,402571241,1270455880,545195497,1443853596,2297992988,4289298164,540975357,3475706680,181206359,3515612521,567068821,117304209,1611052337,2170925870,76908970,158913835,1239984900,3588584796,605608863,3370744394,1244966959,1592719397,3937067248,2262459270,3674904807,2178707550,2861534265,1887076265,4140858974,1027595243,3310463016,2640708710,432775645,1281382681,3764794623,4137783166,220887792,2380578618,3328890620,1135715816,2910302,3517709831,4186789029,835093105,2493069613,1729914894,2210880966,2987557514,2484467955,2605571855,2542303304,55218446,3451547960,2051485235,1341762226,1558978257,2744275336,1429822439,2973046336,2139314274,2417018268,4246173654,3694078022,4093630081,484759601,3572984664,403210476,4251554619,375676638,2480026983,3621470023,2843616627,3569756709,1989996054,1987792405,2304869781,3413070115,1008564317,115419688,884846734,2335499773,800411162,3181387616,3577453225,1470255561,945795120,3958906452,3822857257,2396570112,735149524,1551214620,1967891880,668784280,2117131432,1039154200,2477771526,2079261415,1166147865,829808687,1616677711,3889258342,1449878782,1561133200,325197297,3633597907,1072558722,2022352144,90025993,2480911082,3502087399,332927573,4033149805,249840744,2857857314,759714758,954602447,2180703850,3666546766,347058615,2175759312,2558506409,2919936790,3366306730,458375309,2377723479,1679433757,1988513281,2264743733,2357613122,2869613710,1669435617,1435151447,2670225415,4222330602,2394267999,3017810582,784204796,673063877,2185669013,2271704303,1015763121,3871129611,2650773676,1380487541,2671064704,493935257,305740587,3438189159,2563672582,2120108178,3307297666,2777729263,3669464743,2859599558,4261552333,1246811748,889658983,2897095966,2773622321,4017147491,1246329390,3700747739,2676058824,3756566157,2669724782,2698246057,713077464,3685714923,4033669501,4027976798,285105174,3046820756,3496643294,2734232259,4013568174,1083289684,3654946208,1774828880,2293732890,1357514464,3116388107,2759088924,206366518,1259538125,2869860473,3365737150,2522648855,866883150,2631477077,461869273,1131188372,4216553197,889556563,1880378860,1471931098,3136202569,3882798419,2219068662,3756267643,491049190,3876602161,1387766675,898644951,998306342,1161514957,63955251,2860958840,347172902,2912778564,2867813985,905945360,3546166994,494160184,3981387185,3016583896,985984564,337500291,2419671352,3005777979,3184718749,1662612282,1842133598,3627176823,2236517631,717725045,2651448056,1860450745,3081775459,4276505268,3694136141,1407880802,3144385259,1779820986,1658781566,263759087,3300693582,201408879,3905916077,2246088618,3377403446,1739243280,210018177,2896815648,1951169516,2145060372,3344696627,1740374933,2302646400,3150689816,230455266,2025384857,2609327587,1471227378,1207063038,2781648296,3184834976,2940240019,2494960964,3746797976,1068519266,2771114493,3206354969,3677846740,78968178,2670541471,1416439888,2234460758,917093929,4237793731,864117257,3952131930,1748848436,3694808421,1176268286,2963352461,3502742530,44991024,2363800916,3570661880,3358344406,1869271903,1352366580,927686721,2130397031,183989576,1416360621,4294937529,2914769401,1544662965,41808474,3634474525,3992910879,2178715563,1472615766,482997451,55351739,1260377915,3927873760,2024263318,2530884965,4055252033,2700048654,3832002735,1551101125,1842867844,3339504967,2856244224,4120658318,2987652758,3152119955,3301550802,3746601813,4216590902,2951061914,3122615230,383228251,3639811181,2972691875,1804765838,1239332631,269666658,3545396186,3175766829,4036980783,1041345889,139140206,811631571,2308084220,3475444158,970626954,770494130,3029523108,4067073185,490845741,3170309453,3528205676,220173865,1993315661,2710824511,3244745622,1890861461,993515840,1985836587,295296159,2479830341,101137898,2294616438,69356647,178947183,3755900506,1931692700,407028796,133088143,3887509053,1252463122,1384472202,3886540394,1160254670,2003939497,3886657094,3213991767,3740318768,1184491117,1984430931,2091851237,3686583585,2104103209,3327505480,4285583147,1529370298,2231756740,3594272169,1502288866,3966613967,1315017619,2228139960,804732554,2278949611,1197099530,3993206676,3842239092,2043099511,3942235050,1196268165,1319389818,2008275234,1154599461,3189642258,548499059,3642738526,2064332564,1207396195,3382486854,1584426253,3563152760,3737129937,1384805132,2576596011,1755434007,2550531934,2894330663,3655005159,110380739,3575382300,374761298,2521739184,1510210815,3695501851,4263500327,3909870986,2128615867,809674206,51708986,4021978373,2936012245,511188955,3921377651,1001172496,3082592660,628115255,1463898236,3146148240,1389591739,1454659695,2157734625,3229077190,1603416970,17732929,1587198482,2491065154,773522923,3403044615,3664611160,3183391961,4273266046,1033632743,479641899,3950150180,3512305631,94482165,4276567340,644015813,1017237200,3851006968,2297291565,1005777620,2518552780,707673470,372207794,4233356616,567135556,2624491411,3191120727,3443640747,3358192502,978420953,1490434524,4127056430,3728290008,1332782339,889061984,2827204445,2271999819,119960073,2762863670,750210970,4043453629,3447620438,3606028619,2908018015,4283051312,3936657117,614136032,1197362524,2681798413,3892889611,875704026,2764576686,1624447725,3374217387,3121010499,1067338941,1078127468,2211006830,3466581425,707619311},
  {2064708543,2810847343,2343350222,2628682833,3668393377,2196328720,4228726622,906731124,3575508222,2812103164,1485525077,2143191103,3663886668,842785794,3371409437,875267221,2621476305,1662706168,1410645277,3885317888,3060303725,2580053107,391291545,295768288,603349021,3618548484,1688963578,805434135,3500650669,3844067870,4138254593,1409758310,1800727674,2747099036,3255639307,2305553698,480448983,3428259984,1891411242,2178728480,1886974622,2076408689,3517462193,1412182263,3337745255,535037258,1159749383,3655704054,2266821422,2918197933,1892443901,678160820,1847223441,1852516104,3539783975,1321096920,628044981,2950768792,3354742918,3163904676,3736091455,3013879502,948852058,2076380794,3166757885,1249347924,1655603120,3459470838,1759328007,3095773480,2326881961,3265038956,3711452177,915588789,1864579537,2432577300,1218303856,571332168,879027642,3377419655,1913533074,1195676995,4131281972,2545356933,776133930,4283226562,1854351809,3692924330,1844421492,3745388743,3617892927,1598101030,3247430691,3049502438,1440426512,2807718982,1065225001,2083281458,1053091541,1224569975,4260803756,3954701011,1292867173,1196549097,89976227,4272050789,1567378434,372014356,2155737457,4293440239,3062804702,1349746429,4074545647,2903656894,2221128306,3919395061,819583283,3591650817,3975125978,1322665402,3948000154,733153015,837368029,2727304112,136116635,1212534050,736255681,2784381621,2795680980,457372679,1316342116,1671109395,3890475709,1243332587,933375484,2312237405,3673064578,3311355906,1518159078,838926827,1343091711,2251899101,3169240393,4040591342,3146628142,2147185508,1671903790,1769008634,3003862048,4119728973,2021539605,2214485794,3072280055,3099694650,2171118444,1453804876,4146961227,3391245751,686878975,3186663727,2018502308,2852147179,369779988,2665957342,4216806024,1216426111,308490,3160937370,4210203479,3873034121,452069941,3411495297,54713417,1261908265,3497358404,2412295156,2515619682,2131056255,187777659,2593517724,264827208,270326681,2614947143,2775473509,2276817065,4222454688,2522100803,790494955,3639307620,2616680710,581862645,1847544191,2831074683,3163297551,1081465302,3902195533,881336636,622453698,3435959493,459171799,4272560627,1827942764,1515364119,578100093,46154360,1560642568,4266450071,1453449923,1404060747,3646779409,397880062,2606441540,2326493884,325726765,1514858636,4165739217,2690510584,1735312096,2003536536,260575958,349681317,627623208,585379855,1735583463,3376016064,399183416,2894509277,1808297672,2566751224,1182903804,1504051780,2396543639,752075799,2610353955,3822933218,3591012054,3688390420,3820992250,1995337232,4085449071,1148873385,2140918265,1681360169,523203393,3900184421,1807006094,891195810,665772607,12355285,3954458850,1095998157,3629537474,1006849797,1903074616,2906447452,760177507,3933685056,1665345915,1049722255,1538461211,2694377624,1972996424,3740376582,3903200973,605337691,3703031723,3053986739,837577112,3583793346,2946569946,3867147818,1426346677,2697712507,1944567097,2818162116,297019843,2340350931,234937701,1550289772,2359216103,3170726959,1749592520,339895390,3309109972,1241009542,3892067639,415794827,4199698379,3698144331,908213632,1823077927,3932286642,1782103696,2501058848,830687973,2584618311,2712971903,650708240,2823353764,1378825700,443110593,1241704965,3342156092,2164014192,3016995422,875754415,1611065911,2107529781,991098987,1112224658,2020193942,4196596057,376198763,2539677068,4040159005,961927027,815907477,2539203336,2637310303,753828027,289001644,2864785742,3889231660,2863292775,2034827871,2226532806,3331687577,3657678370,58450777,2103651731,4241258213,3371833356,3677905193,3287840032,3880489545,2888597019,3113357988,709133182,2308409076,3064122613,119332878,2995733116,367747256,1943698461,1359424130,343756603,2412183070,217254634,2402978384,882885560,3813021554,2046147606,1208161676,3061051755,3149098428,3667765574,3300866085,4168599455,372419160,3208750452,4288332004,3003454262,1950259188,1420782592,207454382,1849864456,3950886278,2188207897,1720767877,1563975505,2064436206,949932106,913903345,2632482010,1909964993,3395634629,1999340484,2443870281,2907948321,3939026739,2399857722,1429631542,907838111,3763373537,841203139,1226727751,172813322,2226703857,3145690685,684099939,1755328818,1337471398,3360660354,2025679132,799385280,2641882552,1515595156,3268892439,2728588871,2236651281,2338645830,1896437931,4075357869,3522591956,1273227755,785196591,2458667607,2769160489,266909118,335263716,2989351511,1105674750,800730319,2427806640,3552360750,4191513317,2822163114,1398791829,1039284958,951545252,1562312922,2899277890,1556984382,3779382221,780091852,2397422423,3998882841,3384134081,3645906639,1776726242,2872027323,843714882,26134601,3745418,3967811094,3724542678,573124778,378043004,220553534,1195098733,3758898778,2822801165,2246403581,2881427586,553766497,185971314,2244464729,1678507474,1933304111,1557326637,3420291368,546881647,1117936171,3864470921,27445670,646854021,3213643814,3262465097,152276665,1979229820,2603660896,1737896546,4054595798,2566280357,1835245885,783626897,572615830,1991153541,3317100853,2012970844,2117445160,4144664630,823857282,4051817490,2202514858,2270960120,1864786491,2863911089,1704606915,1702249678,2995892965,1627921200,1188954801,4022977404,2999607630,3362702959,2792389537,2472693900,772524332,3492375169,1790597758,1188271729,2159530327,2912189520,352485874,2483136289,3728762581,3044273584,1101254447,3506879488,3284013914,800475757,3970432434,4063788703,3336462973,3408328360,2219821558,3775145059,4174401364,2039139549,1564313666,3119917853,3126233292,2794300798,2354305154,2262450032,41802254,4017365003,85552796,855946742,1220489835,3031557111,1936567942,3945716655,3658266666,549345510,2797501340,1642149955,4016743172,812087795,1209412491,899020350,3874979404,2412947612,3907219452,2474394378,690280385,1472540351,1022614834,309701643,3421179963,3689720240,1693665898,1398040844,623145607,500054971,58340243,2394614627,910737367,1001086433,2059864135,3259373606,11310759,2378937825,3409834126,2550637130,554775669,1220160323,2693224383,2535139566,1342469270,1997711889,3593750706,2769943600,1018866114,1690670313,598585843,4221837489,2057522999,463689099,2811125869,2281723144,1355775122,3568943959,2123798875,3971544163,581725312,1761931214,2032991770,833571947,288855180,2768850134,3302008532,4087096046,2705458603,1183789184,4049056869,424217977,4271970036,1031530400,1279378834,3150377536,2452497716,704722511,570365923,1004311796,632483102,2581744613,3325373150,2089571647,1331897530,1245622574,3647351178,852613195,2103426585,3846730834,4175901816,2258183872,2420327159,3011995801,843587920,4011371393,2706157787,3256883325,3151881263,1737600274,922307750,2932616004,2521390710,1540545607,1604758028,3172253421,2725046360,1272644329,2833816791,1961722851,3592366033,2371036586,2068007375,424712740,4256912167,3182650211,2855254340,1967846065,965956100,2111646388,281384365,1532923810,1934280736,1747413252,2488836659,3929583347,93477468,885973508,731151916,139412680,2038036202,4143590126,4206294450,678507180,1558217962,837381458,1396058516,1143932390,1949122245,2320722989,2921741926,2583925613,4070237217,8691615,608408204,2305715714,2835106534,3643787421,2567175773,981525132,3139367644,3923919016,808823980,435911868,2586874561,1515762282,450717752,3281317191,1089872776,2221281742,2609762998,2693587412,2749090674,1145294834,3157405411,3847196438,539502133,2141936667,2194806914,1443812531,3362626594,3730154156,771395991,942798116,1914540790,2583324436,298574807,1163493528,1628313400,120885692,1053572152,738356518,3271407317,1991806411,3437395231,3212499143,3785338465,1932973440,4075851748,2898959779,2471158172,1676587158,794365875,240565938,2376658980,116145497,3959693925,572686174,2938336116,1666633523,1749358485,965056117,3812359331,2410533065,775547327,2154345336,1129092518,3909829334,2506390344,4114899190,2454994463,3854060267,3348495828,3385612488,2128550450,196691787,3133683669,811115336,3490451611,3946782575,4002659789,1918022173,310847640,149269369,71331937,965765294,3120663050,2375029773,2525689204,2733757393,1337076236,506401933,3706762607,3103248018,1054856330,548296017,4168149677,3452487076,801197339,609418433,1236627099,3784997918,277590921,3781973006,3195076588,1277780100,3572941501,2180512975,87920910,4057600016,149157867,3043496870,1164709256,3116100471,3971396605,2500553563,1676539352,2767819347,899277224,2957900362,1819977364,2591042602,2588668885,1131592774,3170009438,954017895,3166737633,1416330763,2641901583,3172402107,1679052546,3259768007,3309356985,1393217370,2493626217,802991525,3836719007,27473922,1264897332,831693108,674464823,2957091529,30165010,1623646465,2162129211,80004268,3600240859,2171197486,869655767,3758095726,1260366233,845123260,141345981,4280929473,3243525516,306743293,1611690617,3561583374,2755027866,4186066854,2583207788,178216919,2148747613,2074870497,4284830494,3918671852,2267772144,2070741849,2960106004,1068590782,1024599823,1915964261,2204796261,2798368662,6687484,3504360715,2705504882,2185914430,1761537057,3242798203,3594051594,4117081507,2132853399,3025568685,1901384148,628880848,3283224079,3753313967,4188722600,1443824778,2837074034,3472441841,1955131095,3913129052,3963389681,1067676990,2253587417,2760186227,2141105107,402289921,1662807273},
  {2981522066,2951213012,2554418165,1988876241,3783576100,3421353724,2723237227,2869786506,704580615,1962231891,2083293942,1363437683,182690652,3252768623,1287136052,2705374774,2134915210,3328268713,536835772,2951296529,2337865428,3185179303,2059188027,284127839,2900686370,1781913885,1029202906,3567601499,2127490581,2031753275,4231207797,339553052,3605498409,2547884044,551053545,3098751297,1451270358,2659282023,296898094,2616221172,3650006724,3001385323,1210136915,2973774528,1809691879,1469906547,21757995,1184664484,252006528,3102569591,952831222,1930878962,3046370225,190252447,2930772971,534867023,1944366915,3050225290,2604345876,4018944067,3152305262,1413283594,3027700393,4021369663,4186956761,2292080488,1736135729,3387677128,3407771928,3797897342,2478632524,4237497152,2961256691,675738629,483555515,1351317856,1688895830,3244856626,2179445948,751451532,3348450455,1545475978,1404360651,3517204170,4214247481,4069694041,2454483196,3901274139,1551670805,2744006118,1045799568,2680959624,2337293794,1815260247,726679226,1908452571,4024218306,1840006068,3424889634,977612621,3942424352,3344091787,1823158951,1586172870,985450512,3120539593,2917484341,2948041059,3407982443,2693298315,4211910004,1652915838,2375980877,3220036462,3014497815,1310802164,2756298859,421722543,1997859474,3121079792,2950863556,3875957732,2349807650,559089521,2380056801,1428456783,1671167370,3348919120,2487092346,1352480005,3923794850,2912018491,2316401637,1573566851,2990463183,234282667,3620110736,2654256837,3020354400,2182587161,1938514942,190428772,3378187090,3916422082,3557161883,3803855264,4142454321,2390898107,922192144,1711227254,3567374137,1077423816,3830947,3597993771,2947312935,3686495192,3032019598,3736522147,3516279193,531529501,3965502576,636729264,3648127905,2312749767,2247052154,3270595566,988953981,857562354,4129128352,592143192,2547061946,2297278737,3987983799,1849712266,3385520078,7404017,922374147,3636750591,3354980722,3793552396,339773540,3650734697,1435180591,546353207,4281787269,2253463629,1276977479,2418157543,1410165953,1060973983,1343209375,2337688910,1536020514,2774444928,2471777567,489942162,287007307,907563483,3533954616,3675145217,3071673945,2874841946,1105901397,1132627579,1240908884,230841637,3890256452,2523445964,1389166406,1914336276,3638163284,519041274,369335792,1070542993,1869445316,3006260536,2244468150,1058152943,425206452,29643394,3464111721,2363758153,4009139765,472638102,627354307,382410637,4179050752,846469966,3854336282,3114120489,2897919092,3254666084,1316436937,330221567,1630015564,1875103992,3377388781,689800238,1134491748,39174691,688036650,592858597,505443952,345056244,537501461,4058208148,2030444598,1700292613,1260019689,3719030030,1324318871,809084960,366589802,3042692306,3659461963,2120365548,3111384394,4284843835,4211859449,1253319701,1532991583,1614802650,2018452421,1554454589,3478176171,3758942136,1550734598,1882884594,4222275217,2972439628,986616131,796657077,266168803,2345196430,3181566146,2589787091,4236059034,2435945124,1636280728,2460779478,3666949477,1214972024,1693680466,2625016653,1155831959,2334336826,2903738335,4167275271,153948109,1547352274,821345742,806148257,305505350,2039260223,855262393,3613198302,3710260712,1290246597,500655194,2629558936,3101511290,2899961993,2378385233,1739108576,805565411,1192596441,2266108655,3930764895,2647745830,1893453040,1846153353,1727102086,669685303,1857772578,187721599,2136913778,2863061878,296499997,899256747,1883425473,2044124811,3061204529,2964640609,1747054094,4013138223,1521910751,2678234558,42382717,3342794329,4087570506,1178695296,1680347798,1972844492,3737268334,3501644654,1688588830,428541880,3581787064,1052918337,478428518,2900853146,2869039942,1741566676,3823594216,1295227870,1301597907,1980508970,2759107801,2328721338,2912559092,2232166496,685152756,2272651368,3747836642,117199870,4107228226,2180887145,3654491851,2676581892,3607900264,4068237457,1141245884,1345207497,3983002194,2896316524,3609672181,4007452581,3096334232,1386033450,2900548725,2704326987,3353396214,3916715631,118503801,4028859847,2752310963,1111833208,1145242662,2245027738,3801576118,1048350403,3084224277,3082897608,3371214355,3820107041,1749463042,2446188281,992351996,2088088470,529252958,2162665825,296401010,3958031360,3804124881,3453442683,1833552926,804249583,2678868010,1989346119,179571018,3683251788,3493256242,3552913999,1134732352,578005583,3459176265,756825627,1353915090,308318822,3426051430,653130834,720870808,1124837826,1521118827,1041442944,2970907034,1396606248,539045193,3003713215,245585849,1040217968,130664581,4537863,3441985222,6104086,4266887618,1585544319,3577358796,2863258919,80869341,3354551412,1442549903,1310837925,2384099789,3930491744,879367017,1759327085,3079323460,1819743455,284792018,9608128,157390873,904542420,3312822955,2051495572,4006007473,999045575,1679273041,1523563537,212889559,1234239193,432399261,1133685593,348753507,2329524695,934757273,885907931,3736663565,387794409,4289074758,1343493885,501137498,2131885961,2997586871,3032629349,4288551676,926351583,470884375,644778850,562341203,3070803216,2069929338,3982676275,4155027303,3994902048,1612601314,1781756925,3071679793,1148692702,2186326921,1887874631,1999498229,2467959100,2506004849,2510975186,3836509923,4091933144,871799910,3001633904,1290246411,1928939270,3853322981,667929045,582968199,2538076142,4074554591,2397623788,2280872724,1483907408,2632512239,2829865320,1802089146,1639728273,3663856305,1281293975,4266720633,1384984985,596888510,4066478275,2089317012,4038183293,3328798188,4274073550,2513613108,2725980893,1750886062,1162513647,1152687297,3286971542,2100094132,1586140123,2306427906,537290446,1633761376,776863691,536425056,878649559,1832150509,2266490813,15661132,50157330,2998236073,12351901,1105777941,3705930741,1882843895,4114188874,3601823148,1839161780,2841445420,4127465920,4088358330,2362097639,3463374986,4098576762,1350358070,323815979,2435007768,398379297,3547937020,1313102730,2712750235,3746898718,3398808044,2547370543,1631713974,3591090820,2521971744,2354942009,299933900,224149621,3470956037,3423797212,2697454237,1679649636,2541655979,1951986339,1543538917,1005242597,2932969604,1348582294,765814157,4152328201,1002264467,2773719623,3786760425,4119008156,3725847628,2472994940,646350865,3248262685,2304309315,1494031295,2612857258,1733185310,4234387261,1133880679,3015532632,1478495757,56149110,1399599010,3289906435,2094782827,389070657,21844894,2119651152,326732086,1101647316,130044518,2884137754,3256076326,764412401,4242744180,476401772,3645870057,335654429,2940336176,1829373285,3700194002,1373028892,2948734904,3297543820,10582638,2897379033,1191871450,2443017481,3870713471,1786214026,434829628,2031219457,261603213,1755640804,4226518643,3137749007,2758646329,4103100560,1027459599,3052652252,1771945659,3962355951,1305287098,3434030041,3236436730,295487203,4146318635,623957381,1728000104,1795405644,2351352082,2473395081,608763450,3196137187,2669737274,599290211,3632987591,3841973528,4025133077,21125290,4196671135,3572923070,1017694947,1463137483,1071607131,2190977243,2484494350,2661587400,3297372666,3850373939,3335676393,3324575054,2272992541,700024858,4212516885,2143126849,1953171655,1249149849,1311692659,2894907200,4022197868,3736193114,2410219003,3497481208,3329328488,3107544024,372884324,2120709522,1985808338,2884665365,3898371803,4177561592,1173146627,2482961844,4143904728,892681161,3387701912,1333045792,4052591359,593839047,2949771656,4068484202,66113326,1797661675,130960742,2651901619,1435694811,1265650589,2934685075,1242306435,4265025630,1284431891,3082554750,2198905220,3406114741,2642613480,2261111364,2682967738,2990661723,1082599985,1343942404,450905115,1190284569,492049792,2097820473,1764009568,4250174656,3402420948,1813708557,4294761854,3567926050,1590689397,3353511294,1732973734,2021245585,3646738242,1038131898,839030057,1145397900,3161304554,1300543582,2746326693,2577601977,2621951883,3902770792,17106400,2099401202,1438340693,3363997897,3784943526,1784201721,3146634524,2794662887,1962061341,54986079,664516200,2607874454,609328236,2379907936,392703691,215579400,1803866226,2531383223,1636426969,517431640,3295186620,614441852,1819940923,1369621722,1217129804,3433930861,3501006733,611425475,914386961,1114940242,4151850348,3038936993,3771052669,1461395229,2384759429,3177913509,2344035424,2503397770,959253384,1270142035,3248898745,2951157115,4063592194,231968180,1735546705,2691749188,3755637971,3086885410,2772967428,751465968,1345317050,2618143468,3337566929,2566745049,1517182337,485366818,2968039803,1639288726,900225608,3677044572,4212725798,1146441468,3155702751,1204979499,595451399,2209842171,3083331219,1436508489,2262485327,1559543516,40666695,1593559349,2171479732,3129916876,890938873,1347068,3138697209,4026333863,1991198928,3365695555,2463540,3388343746,899799530,529400563,3014044599,1652723270,1778686126,2775112309,578366746,1508844238,1224655664,2698313144,4092090576,1778258559,2572189219,804764851,1797418666,910546931,2037972690,678238125,1508879892,1317671067,302851966,2915264697,1242464213,422713053,1517439173,385994347,3227111946,1886223057,2916163659,1370833121,2337916403,1296741375,1164564953,455089102,1206808591,539629197,3387122201,3513998141,979691213,1328667956,2948118752,3813902567},
  {2914298497,3363353608,4121441954,2290227529,480805139,717066409,3693030760,318316962,271535386,2294692898,2466972815,2086568784,4277017377,3162676676,3518307977,4106666089,1954305573,3851750136,3204280596,3297425820,1921495032,442650994,1049891736,2764662511,1464143427,2036378964,396254694,1284448351,3757793268,1389128223,3317223281,3723350228,730130301,3096925494,1481384567,670374621,1128351449,3244832912,2696489121,3212909182,439260422,1407454426,3049765095,305050020,694806669,3877931788,1536609345,3763821169,321490981,2589525378,2058917986,4125715895,98523796,478391534,3313835424,2956567330,1030493409,3734836081,1927097029,4157425895,336425421,2615058933,3587430775,3318219128,2941572035,560097943,1085142431,3665360570,2977218753,3298362456,3152578199,3012279901,1396716579,229284394,2763750853,1570358964,906480299,3447121697,2261078559,3518631955,3248616838,85948857,3025513753,3799634864,2369245727,2517472241,163258815,2715540263,699684195,2833460260,3624400899,123947706,1517172848,2903799339,1212753090,1804482253,97777351,4095663037,683960115,1034533498,2186847390,1706232877,3104901697,689954193,2600432273,4282388827,2423473661,3409320932,2823064592,2440215242,2587515591,3898740776,2925078535,678325309,1757311882,2862998471,3619155319,3334212873,2157027753,3026921405,1046262481,1500824184,3987192640,4091568041,2114152205,785847028,3865371443,3468635184,2172115009,1200961837,1358925782,117184922,1465453728,1875779204,1184382834,3755583453,2078739604,1441177173,4062333502,2034678717,3024028488,1801305938,830502077,1341223836,2098714955,3932686475,423877775,208484231,639142702,3270028247,3828466671,2265314586,3735658969,1466091020,1912017689,890187014,1112345351,3197264706,2223166976,2015875172,1586509492,1547793443,2069278237,2791839528,2378853341,3318481506,35430601,2302546967,545179551,2973269851,377442512,1333131279,2394493928,3493500420,668794786,3841331442,2549486948,2159111,656635929,3754528051,1186811375,163895079,655920715,4120997509,288047156,158353870,3624451073,1497711368,1523689072,3287684617,717622133,4204358679,2913273824,2842981317,4275812067,2264294390,1201407724,781616484,1249795710,3232298254,1129507482,3184004665,1576786193,1468295458,1764892608,2486781268,3308063262,1632382988,2327384791,1958299829,2088010773,205856617,3640062639,3186394335,1653697314,884791779,2001425830,1536010310,3688730768,3298905302,1279968879,3992717407,1257472900,562963501,3070041693,2768154966,2444057850,3087452674,2180373667,1939335465,2434187318,2899186123,3334695121,799351864,888666740,997183119,2981762036,2252833932,3709078117,3450130597,794448515,2055796116,2100075846,222422395,445947297,3439004504,1749592638,3051322094,3006928707,3891946034,2051735528,630530080,2942861679,2020698378,1888274942,3033356352,3703359817,3245805341,711207814,142323977,306877031,1348590187,2076833527,1648935611,523674017,356699476,1316860028,996440985,125190271,3485869724,2358776443,1223161178,2693675241,1023758719,2793052290,219321633,2625228165,1255037003,2406246693,2655760657,1226076545,1186897076,1101087449,299540099,3289414163,932816819,3278253298,4078072282,369519032,3748123752,2624957194,3357808593,114137299,2014971854,4036463369,1851533389,2657509931,318477772,2991049366,1261494816,2084656131,2497333081,2560873183,1461103190,4097123850,4241117980,3978211387,2201929400,2730248986,3657128082,3843429102,1961778292,1339311089,449276447,1717057257,2088236752,445785395,3045115135,1780469916,930028401,1058290087,4199916755,3342235324,1792691241,3339513627,4271070035,3726844914,4037336649,3519356597,2868065290,689338823,600932643,824922379,2260459930,1935101764,4118883886,3046869103,2913288390,3638591552,443263857,2515741997,1734380224,1989031494,2618398420,2037295164,3548766220,3286154713,2762372789,2377046967,1368004614,934195333,2589900654,3717508807,902039758,355196380,2132815545,3396100346,125103155,4045417352,3943742042,1792552066,3321933691,2797024190,1384400022,64195551,2284677844,2132300447,815512482,2442330653,3548109352,729992256,3548379305,1531245090,1030113014,655978266,74789932,1804200678,2099423769,3531097981,2182551834,1047844231,2703808004,2012637530,1559847388,4093359164,1252689976,3904527726,1134876769,117005709,3927736220,3951627654,2471137976,3478625776,1892021943,2188146213,3696539035,3891606908,172802349,2459272010,4131172385,4161296644,3381380258,850461739,1914193597,881568053,3956461761,3959311048,3587037672,319110398,509321374,3285273016,2865438302,1251349339,1568664113,2528981116,3284967691,2305818777,4061254373,3723498816,189971088,872008319,838233178,3850410407,1938124981,3782377477,2763030856,4249253520,3955821521,3439051960,1949215128,2597850213,3006018381,3292272280,3717933677,2240246525,2634921718,221508610,3091151107,310929579,237243361,1679637763,2702188049,3985296344,359943847,3947345610,3112328762,3076910493,3838549039,3330815088,4166897856,2956626013,2486771986,984881967,2755869207,493681956,1087972285,3588515847,845193982,2158867292,279073901,3878397969,3183103304,1930485841,1923322681,745865519,4041776795,4198853750,3303725749,3856492874,553150335,2635941509,1145558752,2127411713,3477256391,4205494963,2468682721,779213328,179081414,16561569,3623177017,1483899135,2779176258,3199260266,3548402693,1482427114,3526201893,1173189753,1222943634,2839786096,681613809,1437372914,1789477336,2221596655,1243647915,3274836326,3088843327,422204037,2169109718,670019227,3238364513,584923378,111986828,4193355783,325998424,3068068474,2393328725,1250433373,940910763,377955320,329214039,656820121,1381328161,1535278762,2664260254,1783599139,3765856921,4008662475,68058313,1984085086,12585164,3933715752,1378011580,901039956,2384296148,2268050815,1973061904,4237816289,1394334288,2340214465,1538605441,2979980183,1224467440,3927581184,2400535540,1011639248,2434814353,2437068082,1428538079,1098345474,1250522282,720491850,2523752181,555164952,3261477706,1620992865,4090826620,1482540569,1293541305,1703951905,1795604087,3132130143,1013850689,2588769692,4287893950,25345964,119204276,801852119,2509672861,2034485202,3468884285,3665248620,3361080042,1019608452,1846509381,4181201089,381584491,1741482425,2598318455,2496057007,252082635,2484906620,1233438845,3947413353,1664029651,3576947988,524826735,625525570,2055095622,4275523937,3080120247,396456343,2767415187,1085106709,2647764226,1366573842,3251276068,1047422101,2495667402,4046391479,1638595668,849572422,3372148250,4102743069,358679242,1504345965,2939875951,2856498510,4020242036,3793979383,2836298479,990840298,14372654,1994202513,560983405,3674583315,3634414005,904835727,850545629,2626909550,1013972615,202744998,2730915158,562198171,1647638793,1911025350,2684260901,1300031742,827594395,952964379,3910605700,3111051565,1594000053,1246898247,1249904511,2602017381,3633527894,1665242238,2502073201,3537450801,1603008785,1293321291,2294199051,4179496677,3019920162,672734507,815877170,3866138629,2299418208,3988476728,4167940420,769914231,2941082868,2431917642,1387229975,115129904,2199366356,3275397144,4292481059,994826378,2787112373,1897154040,1393823175,2166446696,2711481358,1783894426,158238029,4178563860,1689779431,2205805158,1938475393,2805900952,2983309978,1983907029,3630875045,3641393963,3770879275,1628917999,817747005,2481040456,785077713,1972614693,137062909,397237976,2792388843,4208089931,1679041403,1967843583,3605277336,1418000551,700592248,1311325507,2545503759,1808541475,2454969633,1596563879,2837445108,1133857100,3304894264,2956828994,2282212553,1636692504,450354291,1696038150,2408055930,1620192333,1680097900,2127363131,4145572771,2536106041,3635665156,2409841534,3796161970,2577191026,2194472624,2295056831,424177904,2296736170,2604965544,1363127969,3061316327,2011475186,2815168084,364462231,3314175539,215705397,3203629836,3098898378,1460481365,3387417518,3083265508,43935266,3105585553,2239205427,280939975,1973274678,114063641,1855254746,3973892459,362477106,1340857314,2108442881,3430624495,483779170,1921503392,2495491916,1483919533,3457604744,1211438618,312667064,787481336,3694789116,919608032,667916353,133766714,3298312650,1384389555,852340097,1970948615,1502552589,4228509457,3363489460,603291498,76274699,155979757,622961014,257774800,2323874291,3706827791,2372679747,3505979903,3486965130,840471852,1043699370,53862662,2989974754,2384158383,2593078677,2658860638,712748757,1959538256,3446993646,3700492944,2092480183,3672534363,3630731062,3181285504,2533557123,1941320048,1402015665,1476849184,2776513910,2329526034,4260197574,4102727477,3097172150,3401391591,4078625692,1049861885,4247467904,881914616,2030865306,4184893793,1861230669,1474891353,2254645419,2653452439,1562591048,1704101489,3696685038,2201045307,3514851621,170559539,2916506180,1316108185,3926897884,1189867988,1135394937,3896728320,1899993365,87767464,438952455,3828499483,4115855167,3662554867,3399853221,4246036121,2202188706,3931452754,385306671,3289845383,551971668,808064346,3063121919,1086026286,3993083122,649303149,2066645983,2219179134,1111201894,4059136158,2973733570,2249897268,2325537379,3667880890,2386095351,1653223105,2801261184,1445877223,2479668808,3184177634,1555183972,4179254462,1269802855,2270525390,359332697,1045770948,209789605,1220247260,904356951,606306073,362050645,1005194068,378619812,111465919,3500096016,1428788073,1938726329},
} ;

static const unsigned char precomputed_decode_857xint32_s[precomputed_decode_857xint32_NUM][crypto_decode_STRBYTES] = {
  {36,246,176,115,252,55,184,103,202,107,218,56,204,137,194,239,7,51,48,184,153,185,131,34,0,140,174,118,143,4,250,199,101,206,125,146,28,25,214,89,32,242,241,160,84,92,189,138,36,192,249,241,229,251,22,198,164,106,76,235,23,27,208,63,198,57,127,190,133,45,224,122,83,164,45,205,78,248,242,172,51,31,75,42,13,127,136,45,5,108,178,178,190,7,93,229,187,1,171,252,42,88,184,29,125,212,156,110,52,38,49,10,57,180,108,47,222,55,63,134,144,142,4,132,83,7,43,123,3,118,35,115,90,10,98,229,175,88,48,109,67,96,110,57,12,157,5,201,37,145,26,197,55,126,225,123,15,124,195,7,151,79,170,208,191,230,180,167,228,10,192,190,132,55,237,46,1,148,118,52,122,202,6,78,236,66,131,26,31,106,134,185,1,52,85,194,217,117,87,25,117,216,254,112,244,72,142,175,241,187,186,216,19,212,114,148,91,98,42,183,104,186,204,94,235,220,117,70,253,243,237,169,66,160,120,196,47,47,103,48,0,91,7,53,17,93,16,94,252,110,17,27,221,123,44,251,184,249,94,156,187,105,177,225,126,179,196,135,52,188,24,193,15,183,114,99,169,92,83,160,217,8,10,73,132,71,156,62,148,61,62,27,180,34,67,74,218,39,15,34,208,81,227,206,168,125,67,225,57,57,125,238,27,159,168,134,122,27,91,144,240,101,253,152,125,192,206,192,54,21,104,155,5,153,244,84,231,86,73,86,210,104,234,232,47,107,10,190,138,180,32,67,49,52,145,19,38,32,164,192,57,221,251,164,116,231,52,186,67,139,192,173,129,57,155,131,229,70,182,107,96,27,239,24,57,156,247,107,10,208,63,79,200,231,164,106,199,115,202,155,38,235,231,151,138,11,60,31,195,36,88,102,15,184,139,184,46,193,248,170,206,100,79,141,70,84,30,13,230,35,166,144,56,105,170,133,28,34,165,91,158,18,173,29,222,145,136,15,86,5,144,13,225,188,231,205,77,155,175,73,98,150,214,55,173,203,45,125,245,178,80,36,197,68,244,246,191,136,48,181,190,42,16,183,189,112,53,90,90,215,94,29,45,228,155,228,248,221,253,7,98,91,171,84,254,166,215,98,13,45,238,110,221,225,251,194,193,251,84,167,55,107,207,137,95,83,34,202,240,55,157,204,25,156,12,240,136,26,19,7,135,235,134,6,184,85,167,1,122,213,26,134,238,129,87,97,172,210,252,244,132,111,149,241,142,18,213,253,180,36,209,179,196,172,218,120,186,177,228,100,121,123,0,50,237,114,64,28,162,130,155,4,2,201,4,219,46,132,6,198,244,239,183,23,176,247,193,229,110,202,103,172,18,148,52,196,158,216,223,59,239,58,181,149,239,129,182,34,54,92,250,150,178,88,217,70,161,229,55,158,253,220,21,164,33,204,182,106,148,249,66,74,228,136,175,140,190,85,144,92,71,97,179,104,243,132,18,55,35,211,74,11,3,233,100,123,81,135,178,176,157,162,37,140,47,72,127,130,56,23,78,6,42,35,125,228,128,42,51,229,248,255,12,137,241,49,230,76,236,58,78,219,239,5,63,224,35,88,163,117,128,187,198,29,169,110,236,167,27,62,106,49,154,76,254,140,134,150,79,157,53,167,208,216,10,147,63,205,212,96,244,189,183,251,168,55,130,170,221,235,197,18,205,70,213,115,190,236,45,27,240,57,133,7,52,200,188,107,246,95,204,185,46,142,31,143,208,245,171,175,135,22,109,221,29,51,222,224,79,25,39,37,249,56,27,143,95,143,40,45,246,35,219,112,18,132,140,235,24,59,147,160,144,132,46,57,43,221,239,64,118,84,57,118,201,37,223,6,116,214,75,96,96,177,30,115,164,82,194,29,205,237,37,60,13,32,211,12,51,145,47,64,22,42,40,188,38,2,195,73,105,162,37,68,246,38,100,172,226,150,34,10,135,103,185,147,254,150,245,96,181,127,242,212,28,61,151,33,25,174,186,126,232,14,59,169,15,67,178,61,114,132,142,77,131,242,192,123,56,109,42,68,109,73,67,193,86,183,85,152,17,132,204,54,216,98,34,187,223,156,14,131,250,210,232,219,1,169,159,226,41,207,206,55,64,50,11,104,23,59,42,33,106,5,140,139,74,105,109,243,144,13,14,187,244,107,39,205,56,183,93,65,180,102,128,169,1,193,177,128,133,232,39,38,134,68,191,224,224,159,79,193,4,99,75,214,232,206,9,34,75,63,168,144,46,113,186,126,46,255,148,83,81,14,24,17,16,111,198,113,2,57,83,92,230,134,43,249,164,24,56,43,244,90,122,103,18,42,129,33,128,168,198,184,126,178,103,180,110,187,236,239,146,188,175,193,149,145,88,175,53,221,0,163,28,238,146,113,79,98,243,20,167,46,249,21,171,99,67,78,14,173,24,246,140,116,224,233,210,201,86,133,63,226,107,178,172,37,237,253,147,211,77,16,95,5,93,254,117,116,250,244,221,48,56,134,59,70,220,7,123,202,255,103,84,181,252,50,211,92,110,203,153,57,117,207,211,5,12,8,190,164,205,244,237,49,212,97,185,120,210,160,24,137,130,204,24,184,212,97,71,247,134,106,252,219,101,249,52,34,165,57,86,44,196,196,239,123,83,217,57,142,163,34,115,128,121,108,190,146,37,221,236,166,66,29,11,108,35,16,211,12,214,222,27,87,60,175,140,240,241,251,64,43,40,68,173,201,53,104,53,255,184,23,39,53,239,67,126,9,33,154,4,62,62,114,148,26,115,102,20,7,211,110,37,240,163,146,138,89,150,65,154,201,54,232,13,99,179,253,181,43,64,161,223,141,79,77,60,147,119,176,50,26,68,78,75,254,177,158,20,137,78,58,253,178,235,221,130,96,228,50,172,212,202,163,174,250,77,121,235,21,50,160,125,68,1,197,140,206,141,160,19,53,251,42,171,171,48,221,180,77,139,57,50,161,24,49,206,252,140,88,213,234,195,85,227,194,207,75,180,110,60,25,182,111,14,11,34,0,245,213,4,15,229,152,12,225,52,85,161,218,230,36,100,140,243,143,239,96,226,65,154,69,77,180,60,242,165,255,173,12,144,85,61,95,68,29,61,245,173,227,186,226,219,250,225,131,82,218,169,230,6,217,242,107,11,51,74,245,223,38,103,174,137,83,134,224,101,21,152,96,106,214,107,172,74,178,73,222,87,144,248,125,22,251,58,236,116,153,211,25,47,9,139,166,65,1,74,5,200,165,40,85,212,174,16,123,148,245,59,122,206,58,234,243,155,208,124,194,181,213,182,49,233,191,254,23,72,158,185,75,233,5,127,32,28,117,15,86,28,151,248,136,244,126,169,255,253,160,62,32,56,19,43,207,87,253,204,10,105,253,139,209,149,200,204,33,145,235,253,6,49,181,6,96,46,179,101,129,170,137,149,4,43,213,120,9,4,171,232,73,92,117,229,213,159,219,24,36,74,122,233,200,47,176,52,74,37,248,238,94,240,224,170,234,134,99,218,134,231,152,10,219,94,112,220,129,57,140,143,170,169,127,122,112,94,126,208,246,235,219,63,61,40,168,81,197,102,4,102,157,221,161,203,25,25,89,96,76,255,52,102,224,126,143,161,246,240,122,42,13,58,191,228,141,252,214,106,198,232,165,177,67,94,104,44,0,7,254,171,209,165,84,141,249,113,130,198,49,45,57,153,148,14,104,28,103,198,93,199,131,138,130,18,178,243,248,21,148,15,223,77,155,72,120,136,151,14,145,74,3,56,113,186,205,51,46,71,122,178,170,249,79,209,30,236,92,136,81,146,163,231,91,57,85,64,22,53,177,98,88,131,127,156,197,16,144,214,119,23,253,70,40,47,220,129,214,255,243,49,216,228,28,88,107,247,212,236,128,8,24,59,147,105,253,222,94,100,22,103,53,210,147,71,63,219,215,115,37,126,169,37,42,198,212,22,238,156,118,21,78,123,118,149,133,97,137,35,81,111,203,93,120,29,60,40,42,225,6,142,176,189,52,253,229,52,139,26,78,181,47,96,31,160,189,169,154,59,213,201,81,162,87,48,176,95,56,84,30,248,235,41,44,220,227,0,194,216,142,212,125,209,43,28,168,117,92,168,165,75,117,152,214,220,39,168,220,48,126,24,60,240,61,6,203,175,147,231,2,239,123,25,1,130,69,47,224,117,49,79,139,92,96,102,95,209,231,254,100,107,86,144,0,13,93,241,29,98,19,211,77,148,216,130,242,237,63,16,165,138,120,9,176,93,5,234,178,223,147,231,156,189,208,85,18,216,19,109,251,100,240,104,68,228,14,34,113,87,170,198,83,72,45,207,19,230,56,106,230,250,129,78,16,139,218,183,177,175,20,208,115,175,129,169,181,127,152,22,179,10,174,170,195,165,200,141,64,82,27,87,46,185,141,29,32,26,100,1,78,134,118,53,63,253,134,66,82,134,140,142,212,10,171,225,144,129,99,87,172,138,85,7,104,40,159,234,166,171,251,95,161,181,142,150,34,224,179,252,3,190,46,197,35,30,40,149,169,70,130,239,116,103,135,177,80,139,60,11,192,188,230,172,152,255,157,117,145,72,82,128,54,53,159,153,218,112,29,43,59,57,18,103,154,238,204,6,138,206,152,146,72,94,126,130,91,33,197,239,200,144,165,167,150,183,218,198,6,114,170,205,32,2,254,100,214,80,74,103,30,7,53,30,45,174,172,49,30,82,165,99,206,112,239,46,122,73,74,219,237,148,220,200,106,129,159,141,166,232,223,110,196,32,159,169,247,211,160,216,178,128,42,235,139,175,219,125,233,108,240,94,12,22,240,22,92,254,16,148,203,154,181,222,138,106,208,195,18,249,162,174,48,58,239,84,176,145,64,160,13,218,217,80,189,201,105,26,150,183,136,224,6,234,80,11,79,192,185,28,91,116,164,54,231,76,12,205,6,19,75,121,152,14,171,190,18,157,200,23,145,92,150,78,150,171,51,85,39,217,156,217,144,135,27,148,144,108,67,237,126,83,251,83,142,5,53,236,77,20,112,218,226,187,87,73,167,238,186,83,205,110,231,246,76,68,132,123,24,228,223,230,208,68,29,49,65,16,231,147,163,183,82,215,59,144,53,38,242,128,59,205,79,59,69,51,225,207,3,120,196,134,170,38,112,177,20,68,121,157,173,97,94,239,170,16,161,255,53,210,54,94,211,56,73,116,29,177,37,79,237,216,106,205,179,52,238,196,58,131,216,29,20,56,65,57,144,59,136,40,179,157,243,210,189,58,115,25,99,94,186,204,109,119,83,50,216,255,140,78,133,117,157,199,42,248,226,9,158,185,57,228,110,99,41,176,183,180,74,230,254,77,11,48,220,98,142,234,83,235,130,107,187,186,233,21,106,126,255,222,98,239,164,184,15,78,150,188,196,111,65,1,12,173,140,207,232,170,151,224,133,54,22,79,201,16,191,170,103,129,159,132,12,32,230,169,172,236,123,76,116,20,6,219,127,51,5,92,199,149,3,188,103,128,152,63,137,24,182,203,187,226,119,188,13,153,235,184,120,227,45,135,155,242,37,177,87,254,81,242,71,168,149,204,165,160,185,212,189,147,128,64,175,68,21,182,148,152,153,83,223,98,79,176,63,253,217,43,165,25,24,29,191,212,124,55,219,114,245,180,4,159,58,45,159,80,40,109,84,86,42,47,133,41,190,169,54,195,153,151,252,9,98,129,51,90,191,144,235,52,79,61,104,101,77,58,220,254,109,28,70,141,43,161,176,2,156,199,208,48,130,174,2,84,189,228,140,248,249,211,212,214,68,44,200,95,211,106,111,244,121,155,80,65,96,75,55,103,71,251,126,72,117,247,10,173,242,107,84,185,139,255,255,249,217,187,173,181,175,17,92,90,242,125,2,29,174,161,216,31,252,254,237,171,143,220,129,86,85,198,87,203,244,201,28,187,153,76,3,59,215,31,75,224,152,30,234,150,206,167,120,101,61,218,150,65,60,182,241,14,121,239,160,175,184,103,228,197,236,115,92,132,238,215,109,71,205,12,199,0,212,62,170,142,65,156,245,150,246,19,178,147,136,225,187,210,170,201,196,85,155,80,223,54,18,84,251,154,161,229,175,190,83,31,186,91,153,215,22,109,28,243,216,163,173,47,177,142,138,146,107,23,183,222,73,98,201,18,16,218,115,82,211,45,91,74,189,47,112,159,240,97,173,17,62,110,28,75,8,211,131,96,48,252,145,146,137,190,17,39,207,138,151,218,57,178,206,236,45,164,218,146,180,161,156,106,242,45,182,65,29,77,21,247,188,108,37,76,210,41,150,31,13,77,149,207,118,63,230,147,161,150,227,102,193,149,65,180,112,64,217,55,59,43,118,93,118,159,220,153,17,69,53,207,147,234,61,7,6,118,17,197,136,103,76,34,4,111,132,170,10,90,126,222,223,156,74,35,115,60,196,66,24,143,195,238,7,61,174,182,231,18,18,167,74,138,94,133,82,106,230,167,231,206,20,40,69,169,176,113,119,70,174,169,231,87,159,145,191,48,188,240,222,109,230,153,70,83,3,72,118,229,29,175,124,33,205,188,219,41,17,106,125,72,180,85,198,43,207,112,255,186,86,40,91,196,231,5,133,169,61,60,214,226,27,139,89,207,185,109,236,147,147,97,78,184,183,206,132,138,62,247,47,235,2,214,135,10,74,90,71,148,127,3,238,116,234,3,229,119,57,199,121,170,187,249,234,133,154,77,71,122,74,164,78,34,217,179,119,37,202,209,68,18,20,30,190,115,110,177,32,94,199,31,217,20,55,11,123,99,103,247,71,70,167,156,201,13,109,112,94,120,101,97,212,209,19,192,222,12,115,138,82,43,188,147,153,23,204,161,104,94,7,6,152,39,251,131,172,231,243,218,217,195,70,148,6,28,1,28,213,82,103,86,22,176,175,78,150,255,252,3,90,27,226,68,220,39,218,31,254,138,229,11,233,187,25,224,126,222,165,66,48,58,4,21,3,5,133,186,239,213,253,255,174,219,31,120,30,115,121,187,233,16,174,172,59,148,161,188,183,55,71,112,37,124,80,65,87,144,105,134,187,187,124,211,82,111,88,180,86,225,106,156,128,198,206,119,192,138,51,146,95,65,149,14,1,18,186,154,94,66,163,122,148,235,5,27,46,7,87,214,202,88,135,109,218,217,180,190,189,126,221,180,254,231,251,155,61,43,193,150,28,36,130,114,235,223,135,89,209,245,174,161,5,44,61,231,254,197,230,98,38,208,206,161,60,248,179,137,229,45,227,237,136,212,242,242,59,204,16,30,150,126,61,46,42,178,112,47,22,72,229,83,252,68,205,205,33,147,143,110,156,87,163,52,190,171,201,65,205,118,243,41,200,217,132,81,58,220,57,214,88,46,226,253,245,216,48,57,222,3,165,112,79,96,2,254,52,93,183,131,168,75,247,107,135,9,114,38,7,54,244,173,164,154,79,183,44,189,52,2,241,86,131,126,205,75,161,239,214,95,213,84,173,48,45,74,255,221,158,164,234,224,248,154,36,92,77,94,71,13,255,216,159,11,200,8,232,218,46,50,52,174,23,200,164,237,26,211,96,171,120,30,201,67,215,6,186,189,76,158,63,108,235,66,64,110,73,201,131,177,213,159,206,239,105,45,42},
  {191,243,16,123,111,32,138,167,206,175,172,139,81,132,174,156,161,61,167,218,16,81,233,130,94,63,13,252,116,158,11,54,254,236,29,213,252,73,157,167,85,80,139,88,63,128,190,127,76,121,98,218,2,228,59,50,29,160,243,200,149,132,43,52,209,141,64,156,248,225,26,99,29,189,20,84,0,63,149,231,109,135,104,182,115,124,200,153,153,162,82,23,224,16,161,17,29,96,246,35,4,171,174,215,250,137,171,100,23,243,1,48,173,176,167,208,30,210,31,229,1,193,168,246,102,52,7,84,122,236,84,107,156,103,189,163,11,29,13,194,34,245,107,137,215,17,163,28,144,24,87,204,42,165,188,112,32,194,220,129,158,242,120,112,113,123,195,123,177,54,168,209,247,48,44,84,103,243,241,198,74,5,228,31,7,95,32,69,246,157,229,217,46,243,28,135,173,42,240,173,253,102,204,112,180,233,107,40,145,100,26,110,8,39,107,110,39,209,252,210,216,86,190,78,181,52,111,37,152,40,225,175,134,80,245,199,164,90,149,188,63,59,176,222,206,38,164,179,90,85,142,56,122,14,195,123,253,227,192,188,84,137,119,74,176,127,174,98,246,85,51,206,7,55,221,104,40,193,133,184,169,102,177,138,108,138,156,194,17,68,56,221,181,198,146,54,209,57,35,111,20,47,254,144,112,215,157,72,72,214,13,34,186,229,100,52,135,85,79,201,146,50,14,114,67,149,68,71,52,92,62,246,133,16,183,151,42,221,66,46,194,217,76,255,193,41,135,110,170,141,29,220,116,163,239,109,199,24,62,223,63,170,164,215,38,22,65,95,35,220,143,193,230,182,195,181,16,42,219,85,70,100,90,167,41,11,126,63,50,90,44,124,213,230,196,62,119,116,253,72,172,180,246,253,211,242,183,235,101,150,15,77,233,227,81,71,163,237,92,5,101,82,162,254,2,76,108,93,20,125,44,22,113,241,125,128,239,178,232,255,222,176,142,182,253,126,115,80,239,161,220,242,190,73,18,173,114,186,99,132,245,56,157,233,51,217,217,48,1,62,20,214,218,155,239,236,186,69,214,78,154,179,81,235,247,6,179,43,221,56,233,49,176,91,143,162,155,249,28,8,34,205,69,72,193,94,226,43,181,74,246,165,212,180,162,166,7,244,66,27,100,201,117,78,19,27,155,99,189,242,227,231,235,191,27,74,252,45,162,55,93,241,209,137,130,132,238,218,2,72,95,197,230,68,125,90,235,1,1,50,255,243,13,80,221,64,57,134,73,197,230,188,238,135,214,240,46,188,141,187,100,115,251,127,46,58,167,99,250,237,112,105,32,76,11,179,77,19,142,245,21,63,126,120,34,95,254,131,247,69,31,183,58,150,193,184,108,163,104,129,76,77,167,86,75,155,45,247,183,77,34,202,255,240,240,40,47,161,240,189,164,230,79,120,235,79,0,170,20,101,10,22,222,71,231,158,136,90,87,251,127,48,129,72,10,181,4,0,154,19,104,188,87,155,242,250,137,207,217,230,53,10,242,26,129,73,87,203,73,220,66,3,41,49,55,75,68,116,117,208,244,179,200,143,98,79,241,149,127,86,5,127,123,66,49,11,156,240,149,154,72,241,200,15,153,219,28,16,71,237,220,155,101,93,110,165,169,120,181,135,160,139,173,251,67,52,84,150,235,254,29,47,100,109,235,216,6,97,247,155,245,132,174,34,127,73,31,110,123,197,190,168,15,23,140,188,214,217,117,64,77,199,150,232,60,33,136,52,194,227,25,37,197,148,204,204,215,103,94,27,243,25,170,254,108,49,244,108,23,159,82,90,125,27,117,34,120,66,192,2,8,132,5,93,151,220,76,254,195,226,161,86,75,68,176,83,17,112,93,217,254,42,183,23,68,36,91,155,188,122,171,138,45,50,106,19,140,232,74,90,209,34,76,248,248,238,93,160,224,194,110,103,152,138,107,119,214,18,136,15,165,182,215,20,40,197,104,37,15,48,228,34,231,230,114,103,192,234,57,201,56,14,203,23,221,180,134,172,200,110,200,107,248,131,253,152,252,173,129,70,68,2,166,89,151,90,216,142,23,196,211,44,35,215,150,155,226,84,221,227,214,126,10,214,20,95,216,219,250,182,191,227,16,110,238,118,111,1,131,243,169,106,122,68,249,209,155,127,41,133,55,100,65,115,47,31,101,23,120,232,142,185,180,107,162,145,30,53,63,226,174,39,213,134,188,0,226,64,180,235,205,154,83,65,194,88,86,216,5,79,3,60,56,157,110,113,92,222,60,173,99,99,79,45,64,69,119,234,123,41,67,99,143,125,145,62,27,14,179,91,152,240,152,160,72,137,153,117,6,158,241,222,205,30,166,232,91,184,20,36,171,199,183,220,179,35,8,182,152,105,236,49,194,88,156,213,218,22,161,175,42,254,127,230,181,82,4,85,123,211,203,160,57,189,231,115,196,189,249,167,195,41,180,17,211,235,126,139,101,221,0,14,108,139,103,92,231,199,158,140,47,116,253,188,200,169,72,104,94,100,66,20,212,2,61,197,134,77,248,73,55,61,252,231,139,134,200,24,203,79,82,250,75,52,109,220,128,61,34,54,39,246,169,108,178,238,97,234,144,190,56,106,32,33,19,149,229,74,131,49,71,37,14,154,127,170,180,161,16,5,201,38,164,245,72,168,228,53,47,82,193,84,105,26,5,234,2,74,60,65,53,199,112,60,252,128,94,178,211,179,175,243,50,52,55,234,6,96,53,90,158,125,107,248,18,59,146,51,75,66,150,182,105,120,89,249,34,250,107,86,108,22,140,101,96,151,29,239,207,240,115,215,85,57,149,194,161,48,8,43,89,151,95,41,50,157,187,128,238,44,172,208,57,17,78,41,193,170,44,247,208,231,103,97,170,170,95,2,73,121,198,49,182,132,153,132,149,198,34,190,3,218,89,227,123,3,147,45,99,125,229,118,204,252,12,24,250,200,41,97,56,219,32,117,248,195,73,146,75,231,27,126,44,172,164,18,146,185,126,131,68,42,244,134,151,137,245,204,162,182,14,224,28,7,124,66,143,178,184,96,235,21,29,124,218,115,130,42,7,81,59,79,125,20,30,254,198,143,234,10,243,12,80,138,58,143,184,195,159,52,114,23,70,227,22,188,245,121,140,21,3,72,107,241,115,182,188,109,179,187,70,169,157,218,37,56,191,196,159,199,119,248,88,170,50,22,116,165,65,191,228,192,154,255,54,19,5,179,244,151,62,116,0,108,175,84,174,128,93,12,8,177,66,110,134,189,125,235,25,103,109,130,133,213,144,102,81,95,56,93,238,203,12,123,74,208,158,56,241,14,121,54,218,124,232,156,193,192,215,113,197,69,101,202,196,131,43,119,73,128,170,145,33,197,83,173,51,199,200,234,58,236,10,143,54,114,54,85,159,130,28,54,225,133,80,224,195,189,35,50,71,97,30,73,10,236,76,10,241,205,184,132,61,110,127,187,99,137,198,40,50,49,160,104,166,49,184,79,130,155,79,200,28,105,189,120,192,166,165,47,184,237,119,157,148,37,86,90,23,87,215,194,71,246,162,162,17,151,80,133,70,231,100,139,171,88,9,113,173,6,233,242,212,124,246,209,235,233,227,75,47,38,205,46,87,74,140,146,41,9,14,165,190,181,232,15,228,183,251,19,87,226,45,178,254,65,231,65,207,44,186,47,176,99,181,144,46,185,188,211,229,106,213,249,170,202,54,168,149,222,95,83,222,58,242,61,164,109,183,56,218,0,31,93,66,120,207,172,62,178,205,92,205,203,68,225,204,65,127,46,87,195,229,142,25,28,90,238,193,201,181,201,207,30,80,217,226,176,230,105,187,168,47,171,66,17,74,50,73,200,142,1,138,38,57,0,22,254,127,236,214,2,0,222,170,48,41,34,124,122,136,22,62,97,37,13,109,194,59,71,90,62,12,224,13,135,64,168,253,101,229,133,130,24,191,171,97,206,1,33,114,178,21,11,89,208,199,133,210,253,11,100,47,225,59,115,45,235,210,92,40,129,221,203,111,192,152,32,43,90,162,66,137,37,87,230,166,201,162,1,133,53,142,38,38,80,140,191,73,68,117,194,185,142,19,9,124,166,248,117,96,182,48,155,98,50,150,103,214,56,172,241,165,84,246,152,61,161,99,109,145,50,181,46,150,108,33,34,133,151,174,118,53,241,182,197,92,127,251,119,40,166,53,126,54,144,10,247,130,16,27,49,18,212,129,241,170,181,71,131,248,25,92,135,59,98,38,111,177,208,179,170,195,60,154,101,206,68,118,101,229,178,145,178,48,27,8,97,177,2,222,70,124,195,201,239,78,97,202,178,111,198,110,200,161,123,112,166,140,80,98,147,44,201,11,46,129,106,41,208,126,90,186,106,113,150,211,70,87,209,183,128,80,124,148,173,242,129,2,21,33,167,1,148,213,102,64,222,176,237,115,181,47,207,163,65,0,188,6,209,90,19,190,195,109,74,182,47,178,253,167,236,159,126,56,242,125,98,222,198,168,246,38,203,246,201,79,132,99,36,4,225,84,79,208,248,221,204,138,121,66,136,61,93,29,43,246,185,204,136,86,186,126,165,141,166,130,216,83,140,112,63,218,134,14,218,125,2,11,32,116,239,156,110,25,5,246,181,4,51,107,50,191,72,247,227,177,180,134,174,109,115,175,219,46,235,42,184,12,218,230,88,190,32,156,123,190,166,67,56,225,97,4,163,106,239,243,121,103,48,139,43,22,72,62,246,149,53,76,126,247,230,156,168,210,143,252,111,227,232,10,67,124,147,193,215,36,41,191,46,197,87,50,221,243,60,11,172,117,18,59,16,235,203,176,169,236,219,106,74,243,100,12,105,84,83,135,114,36,37,187,59,206,29,147,51,122,3,99,235,186,142,215,191,72,54,225,93,171,59,71,8,199,122,38,24,70,194,167,150,172,0,225,181,203,141,142,240,61,203,74,162,7,152,117,52,17,33,67,43,186,72,191,87,135,160,238,40,27,151,150,116,4,80,17,170,18,119,178,72,52,214,48,252,25,165,194,169,186,60,233,148,197,100,243,177,173,35,177,32,164,251,55,79,163,122,139,85,163,27,109,96,142,167,8,85,0,136,146,124,207,80,87,195,185,212,91,153,150,126,99,244,184,236,128,108,172,34,206,239,4,105,26,254,44,121,107,76,175,49,140,148,55,17,214,76,9,165,212,166,208,196,238,34,156,243,171,5,66,161,128,48,143,70,101,180,87,241,121,13,73,25,244,22,161,254,160,231,123,61,146,197,65,76,64,242,198,187,52,37,46,146,79,54,1,42,227,23,255,33,244,148,220,59,30,237,178,37,229,75,226,153,222,42,53,198,63,85,140,124,186,36,99,79,46,177,62,74,138,41,102,217,75,216,209,50,25,190,95,125,82,116,72,229,120,52,231,248,192,38,153,134,247,66,67,144,153,104,135,179,80,33,72,50,129,171,24,239,219,176,76,161,125,24,32,194,47,228,221,187,18,173,145,103,166,76,249,54,68,43,204,174,118,94,73,150,71,220,210,91,12,170,166,95,237,190,20,189,88,232,108,162,233,2,219,75,215,156,232,168,227,131,237,116,209,39,31,214,170,37,83,141,207,73,67,123,36,154,80,25,39,83,187,253,99,99,179,189,68,185,47,170,177,242,74,117,4,82,147,57,180,42,221,125,173,149,197,16,162,143,94,91,32,200,74,115,4,105,39,104,51,162,88,148,243,174,56,234,92,90,146,5,4,226,206,52,44,126,148,43,200,68,79,8,234,246,121,121,238,42,250,246,178,245,182,250,172,50,113,40,234,132,224,92,82,109,233,49,148,41,54,83,230,5,47,68,197,62,45,116,45,108,83,138,102,62,38,174,109,147,3,154,33,228,154,242,159,159,132,0,140,146,67,36,2,110,110,137,230,74,252,168,157,200,47,217,93,254,3,153,140,226,128,58,220,242,30,187,168,64,226,233,172,172,53,48,188,124,251,25,193,146,48,154,106,178,88,90,56,104,221,26,71,237,148,195,136,35,246,64,206,17,102,132,182,210,141,155,212,225,140,160,114,203,219,163,242,207,67,68,227,46,50,188,22,143,79,229,53,38,40,32,27,92,171,127,130,24,210,130,179,212,14,86,34,156,109,200,172,162,85,222,151,145,250,45,36,245,49,56,246,146,29,114,20,103,250,153,215,227,203,17,152,128,89,69,56,23,14,97,188,145,52,7,56,60,204,62,38,109,2,44,213,182,253,194,203,141,184,118,31,125,226,204,199,216,122,191,97,174,159,225,128,213,54,115,228,143,240,242,163,157,202,172,156,225,74,147,150,176,238,99,179,15,89,47,178,190,86,14,36,240,168,141,89,61,236,6,101,34,4,236,94,127,34,34,116,115,35,175,51,207,86,99,149,23,69,104,117,150,133,57,163,252,59,227,201,208,173,143,191,233,57,46,120,179,104,128,166,149,76,67,214,66,11,233,72,123,100,149,246,96,68,245,31,62,84,146,235,74,184,229,212,253,149,199,200,88,204,201,50,26,223,126,75,71,185,11,213,55,200,186,72,163,88,48,155,16,12,208,111,31,63,235,205,189,147,238,29,178,82,114,152,40,135,18,121,171,229,8,97,112,64,4,174,104,144,57,10,138,1,186,13,20,144,141,116,245,138,150,209,211,241,162,12,42,178,79,141,20,47,30,111,181,240,220,146,206,247,184,138,212,223,62,81,85,174,32,173,234,112,248,164,197,200,205,27,77,193,47,193,252,82,36,155,110,181,73,30,124,154,225,137,179,139,16,14,84,108,225,236,255,112,190,132,96,41,76,189,194,246,212,207,252,247,129,14,145,61,5,16,16,218,241,235,247,227,8,166,19,104,181,136,13,108,69,119,235,187,185,253,179,182,236,91,107,11,149,216,245,237,99,83,146,249,164,168,225,153,53,74,250,77,176,148,166,122,108,42,44,112,154,213,243,75,154,70,188,114,67,94,129,242,188,103,40,221,56,225,148,192,188,11,126,107,84,15,56,120,157,187,3,23,189,2,79,20,100,199,28,76,194,185,199,64,197,90,207,10,83,105,183,161,148,165,173,220,47,159,175,175,228,2,56,163,1,52,205,100,75,52,161,146,49,55,132,51,40,201,162,65,176,18,72,204,1,1,225,198,96,59,121,223,128,172,196,196,4,219,80,151,214,46,216,105,129,215,228,213,51,110,253,255,223,153,169,31,75,188,142,95,50,189,196,108,8,193,204,41,255,140,69,84,193,253,135,72,18,121,114,16,96,14,115,73,212,154,99,54,164,166,79,130,249,108,159,248,153,215,95,159,10,93,73,19,128,225,2,172,123,30,83,101,255,236,47,146,233,240,116,43,135,89,3,109,123,20,162,111,176,190,102,177,63,15,39,18,61,101,75,51,114,101,133,106,131,150,183,203,166,252,10,102,0,11,77,224,208,114,186,66,161,62,104,74,130,33,236,254,104,123,44,73,193,10,224,56,214,163,173,101,245,151,194,32,127,173,131,86,180,212,209,84,113,208,245,123,37,15,6,178,195,175,6,183,223,168,213,170,249,138,4,15,86,114,80,26,169,241,65,249,206,215,238,136,116,92,156,61,233,241,134,60,236,62,117,163,63,217,3,83,134,115,25,133,164,211,171,158,127,1,117,250,23,233,108,28,99},
  {146,106,182,177,212,239,231,175,245,83,65,152,209,215,139,118,36,202,132,225,252,182,237,203,107,77,81,162,138,119,13,171,7,12,255,41,83,72,245,116,246,138,44,124,115,104,68,81,92,163,227,10,111,79,225,193,52,35,184,76,54,190,64,161,138,56,64,127,169,89,97,198,188,118,255,31,17,54,233,175,212,254,88,139,167,250,217,189,59,183,188,122,95,114,239,16,34,246,228,172,29,217,53,106,218,99,88,61,91,71,165,212,21,238,206,126,59,24,26,121,117,27,51,252,28,43,61,20,41,138,231,214,12,160,221,151,233,104,216,32,65,49,179,184,214,160,128,86,103,108,129,158,46,78,178,17,244,93,240,155,196,174,142,217,107,129,229,178,83,57,33,72,192,50,64,177,231,180,221,107,115,254,156,87,43,0,76,1,164,139,156,70,128,80,5,15,119,116,237,184,246,12,203,56,242,223,22,115,177,235,147,181,159,5,87,11,235,11,176,174,79,108,225,31,67,175,228,115,138,190,206,181,20,42,59,155,67,56,140,239,110,92,228,187,10,255,60,84,169,10,119,180,63,59,177,239,217,227,143,249,104,95,158,136,49,84,123,103,200,217,235,201,24,121,30,203,126,80,95,226,76,238,188,147,64,19,147,252,243,48,129,176,5,244,70,40,187,120,210,28,96,121,139,80,86,129,170,100,50,149,104,193,188,180,231,129,140,61,202,44,151,76,149,199,138,23,30,92,203,215,180,83,202,70,164,209,57,80,48,251,89,154,146,242,252,112,76,146,27,184,136,232,21,158,124,92,230,53,142,163,144,162,85,62,136,50,204,159,226,69,80,139,87,172,50,108,186,62,80,43,219,172,192,113,194,178,220,239,180,67,172,109,34,171,35,204,77,47,69,58,32,159,252,234,139,202,82,199,167,50,171,108,198,19,139,94,16,200,188,58,201,167,255,185,53,71,229,173,99,137,183,175,107,175,33,203,139,120,136,160,116,165,12,251,126,126,133,98,77,151,158,141,110,219,237,191,23,150,173,179,244,64,33,78,107,200,73,164,175,249,34,25,146,234,20,119,240,229,7,186,196,154,226,175,228,107,6,231,34,56,15,140,113,7,83,33,225,200,220,141,79,133,36,85,138,253,155,99,80,115,156,199,122,4,62,148,5,53,157,80,162,91,224,233,59,224,145,173,229,123,17,138,131,185,202,93,207,216,62,178,171,222,246,13,144,129,198,215,197,190,52,158,96,243,6,180,25,163,23,130,254,99,139,115,100,182,89,11,82,11,91,201,194,219,111,233,155,251,5,212,160,57,186,226,49,214,232,246,187,53,130,142,16,137,247,54,118,65,255,101,57,207,161,212,200,46,56,64,163,116,58,0,43,7,117,214,39,109,172,175,216,115,187,219,142,242,184,180,163,205,182,222,153,41,150,209,29,127,174,31,112,196,92,236,176,183,243,37,161,3,114,217,199,194,217,137,122,75,239,133,238,83,241,194,125,61,242,58,242,92,29,51,160,127,29,246,88,99,75,35,186,20,209,151,17,177,237,136,183,205,179,237,138,94,64,110,206,239,202,201,241,249,112,0,3,80,250,54,255,104,196,216,114,241,248,199,12,4,29,226,100,136,64,20,105,202,153,217,47,30,139,85,55,176,144,32,133,227,54,255,77,32,81,134,71,33,29,76,231,39,34,144,193,108,13,84,159,45,61,63,159,191,15,80,78,77,86,139,34,208,141,91,128,171,94,165,31,85,84,147,146,236,51,29,75,98,27,17,219,81,24,54,56,222,163,210,1,68,14,219,89,6,22,183,90,155,90,171,85,183,234,65,123,134,130,67,84,196,246,73,37,93,194,13,68,154,224,231,204,186,104,150,70,255,204,82,20,116,26,114,84,247,217,216,250,240,239,30,240,157,3,22,145,48,207,63,196,120,109,111,56,229,47,179,182,221,199,133,239,33,18,63,180,34,88,25,130,82,196,1,105,38,122,206,73,22,228,140,53,158,246,238,150,226,43,28,195,170,100,37,141,31,203,22,0,65,23,249,78,27,116,50,26,129,188,229,41,181,157,185,116,188,186,172,100,67,254,193,201,59,119,78,255,199,174,19,76,16,40,97,248,208,195,111,237,220,78,201,46,132,29,41,100,248,158,67,35,194,85,2,42,155,2,41,229,77,86,35,112,118,32,30,244,35,145,20,21,159,9,32,148,87,227,241,54,32,6,121,5,104,88,101,233,95,26,75,14,229,171,221,151,128,239,78,32,168,57,48,106,183,217,21,210,204,91,181,75,245,30,218,236,53,98,126,74,245,115,185,59,135,101,255,249,223,11,251,21,36,180,74,95,152,95,91,218,238,63,96,197,35,79,120,61,24,167,92,171,193,80,207,184,231,12,224,6,85,110,92,242,137,58,112,145,206,170,251,76,212,43,177,67,145,206,58,181,5,124,47,227,105,221,15,142,219,200,139,194,216,162,189,211,3,93,154,154,33,125,252,164,146,49,145,152,169,135,97,214,131,172,146,101,53,145,218,120,0,107,72,82,131,243,100,77,147,118,156,151,152,228,68,58,39,35,139,223,135,19,173,7,147,99,248,205,15,45,9,210,184,58,92,206,189,244,48,161,216,12,48,70,164,53,18,63,164,140,121,185,68,250,50,222,7,93,215,232,21,38,221,197,153,231,76,90,100,215,29,152,226,187,156,122,78,221,184,137,232,217,172,81,71,195,141,224,176,168,103,227,243,3,48,217,147,21,71,239,18,18,135,95,182,74,234,38,101,209,157,240,204,219,112,137,16,10,110,134,124,241,102,55,150,234,39,34,92,187,110,127,103,48,11,114,183,94,127,118,219,166,170,29,59,172,17,171,145,153,53,193,202,66,112,139,222,214,121,49,70,118,182,97,211,180,176,14,238,33,104,47,161,51,239,223,131,182,90,190,157,162,159,125,181,134,2,89,254,62,199,74,96,163,243,128,118,65,70,150,18,40,100,204,55,151,117,110,48,194,222,110,219,182,208,30,210,165,100,184,7,139,25,184,187,125,213,65,66,194,62,102,61,132,28,154,129,231,172,70,19,2,171,212,50,206,103,232,106,231,227,222,155,51,77,211,206,148,77,42,43,12,118,217,164,116,164,186,119,205,138,244,31,154,173,96,40,12,133,244,153,214,40,104,232,117,135,226,114,99,223,254,83,252,6,66,84,207,244,105,178,253,129,203,30,211,217,4,102,137,159,104,48,12,215,145,96,124,242,188,7,6,68,201,60,46,80,82,202,103,237,108,72,162,172,245,57,39,215,165,223,220,238,152,79,142,184,42,49,157,82,117,220,226,172,75,193,48,161,246,195,224,199,111,86,116,233,121,57,16,7,199,133,35,240,179,238,12,164,120,58,69,66,38,4,67,68,154,103,208,133,182,114,151,226,195,142,124,62,21,135,213,183,200,72,193,183,19,166,240,200,33,53,178,227,2,176,70,104,249,222,205,145,252,22,38,59,150,179,117,124,94,194,139,31,97,169,231,128,114,184,170,17,0,196,234,235,209,86,190,226,123,90,215,205,30,204,73,109,239,223,239,47,42,72,172,159,71,3,147,118,74,9,180,10,76,246,137,219,50,220,54,208,79,42,197,211,64,164,162,67,79,170,115,34,73,215,46,206,27,62,28,45,210,26,179,80,102,146,96,18,102,101,53,204,82,252,237,38,152,157,247,42,194,169,11,67,107,110,170,90,128,40,19,62,154,113,20,177,40,133,62,83,73,45,33,32,191,6,9,179,185,87,163,14,112,119,0,62,133,200,201,7,7,62,69,0,198,134,40,205,22,36,93,0,194,137,83,254,127,124,129,94,204,41,58,213,39,221,169,170,221,247,209,4,116,100,242,199,143,144,251,85,165,204,33,78,205,121,26,142,96,139,70,234,105,19,106,52,109,51,221,104,68,191,138,183,223,20,119,108,210,148,249,16,192,155,146,0,25,152,97,9,212,56,234,53,171,170,117,197,148,86,71,122,177,210,198,238,199,57,140,59,81,172,23,100,17,188,207,90,215,111,176,12,217,254,144,73,157,227,197,25,89,171,146,67,99,142,201,20,215,185,217,138,153,67,183,55,219,225,205,52,13,246,184,222,233,69,29,23,70,22,166,255,253,22,20,80,90,192,222,29,137,255,17,127,183,139,171,178,101,64,194,180,252,26,158,255,223,0,55,55,23,32,17,28,98,139,110,38,83,165,132,33,16,189,8,183,122,157,96,123,51,209,98,237,103,175,168,247,32,94,29,238,226,87,30,96,253,115,51,106,49,29,22,183,222,168,119,68,137,179,80,130,71,174,134,112,245,235,45,119,60,17,26,147,113,153,94,149,210,112,170,149,227,126,172,228,216,241,229,243,102,156,246,51,112,76,233,178,11,153,231,76,6,71,249,114,229,10,173,229,213,201,207,39,135,99,191,34,238,247,71,151,223,196,220,242,236,213,232,142,20,91,243,135,80,161,114,88,239,242,232,156,104,81,172,168,186,178,105,107,145,68,188,97,177,2,98,218,151,254,94,76,121,253,80,254,153,49,141,82,190,203,147,35,195,136,97,242,148,114,136,124,125,201,177,240,236,109,105,198,206,47,193,254,52,177,210,149,221,42,123,162,174,102,92,104,239,140,74,69,193,156,180,68,150,52,235,195,180,228,44,125,219,147,138,94,2,76,121,137,206,102,6,32,96,56,97,97,203,255,77,46,96,50,249,31,215,32,95,52,237,101,52,109,189,231,23,135,76,248,238,0,18,87,253,2,169,115,181,178,157,121,188,0,21,213,232,65,245,3,228,220,247,234,57,112,74,138,57,245,172,117,175,214,180,97,159,109,44,4,93,169,192,33,4,246,186,101,175,243,231,191,202,140,138,232,110,206,122,81,75,244,54,212,124,80,43,10,77,19,24,69,35,145,33,201,190,23,252,56,121,211,138,91,68,78,155,72,177,161,30,35,85,223,236,177,149,202,47,202,213,151,182,250,65,97,132,178,11,214,32,60,82,150,57,144,93,140,204,160,224,17,117,64,92,13,5,150,226,206,220,255,18,204,157,226,199,160,100,107,29,100,171,151,126,151,163,242,88,116,229,136,0,92,229,200,234,59,132,144,209,174,150,187,97,80,141,101,165,45,9,128,127,247,147,87,189,59,71,154,83,165,233,96,181,225,156,19,131,245,76,236,19,222,124,232,102,147,17,136,134,38,29,142,156,193,67,248,88,137,191,27,13,89,170,9,189,155,30,79,78,103,61,159,99,252,103,165,149,67,88,96,189,179,13,14,32,88,118,196,88,3,162,47,108,83,3,253,23,196,107,217,219,124,65,191,48,23,158,83,77,1,80,79,87,126,54,137,121,19,212,205,169,65,102,82,192,7,26,115,232,171,38,200,19,194,241,1,144,45,116,35,227,252,108,80,101,28,233,143,79,217,29,174,1,20,48,248,65,175,101,5,10,109,210,122,140,220,28,194,214,81,184,31,194,175,140,134,140,196,110,122,161,0,217,126,178,172,218,131,10,71,9,125,157,145,127,102,182,230,138,118,119,106,60,249,234,25,1,243,17,121,141,191,151,15,228,243,164,104,115,142,235,251,15,64,6,187,57,154,109,164,144,88,144,244,15,202,61,61,220,198,243,181,187,190,157,105,239,192,44,236,186,25,205,77,217,35,175,204,250,26,232,192,227,198,156,17,43,205,35,247,133,213,48,37,104,48,255,102,76,183,3,107,18,201,38,140,137,3,109,147,58,254,72,36,227,46,129,190,58,245,32,159,99,113,184,35,199,253,138,216,24,221,255,228,21,168,234,239,170,88,66,1,159,30,36,250,190,122,246,212,227,202,168,60,203,180,53,87,91,109,223,63,219,168,151,130,14,96,22,148,200,153,164,158,250,233,137,196,51,11,128,229,233,97,210,198,78,253,40,198,29,29,123,135,26,136,185,41,21,232,21,251,65,133,189,127,199,8,107,116,153,131,116,74,115,215,46,78,64,199,140,172,108,222,189,239,90,200,177,222,251,5,169,143,248,83,119,208,104,133,113,198,216,91,57,185,100,195,57,22,146,117,103,126,210,7,93,118,21,128,240,171,219,110,92,232,248,135,0,249,3,204,236,69,180,253,254,147,216,247,254,246,201,59,53,53,152,58,236,201,32,170,116,79,255,162,141,241,199,67,101,35,136,241,209,175,106,36,128,242,46,207,240,3,235,35,38,107,102,77,206,7,179,206,16,158,219,246,146,85,157,75,112,75,147,189,235,174,131,23,12,74,94,32,55,254,19,224,142,76,126,13,188,183,132,161,16,131,181,47,5,203,232,20,131,157,68,210,197,134,186,214,234,159,91,224,65,178,49,42,135,64,4,239,26,80,27,68,224,26,25,77,242,70,128,21,84,29,57,51,10,125,96,166,36,105,192,132,84,253,212,210,204,202,13,255,26,108,126,221,252,255,34,59,170,212,117,254,207,94,126,133,226,199,166,20,75,103,145,194,121,120,66,207,92,217,186,162,224,61,41,149,2,50,140,98,69,68,234,173,109,188,94,184,132,77,165,158,177,163,185,21,163,153,139,207,71,156,104,142,159,232,224,5,5,1,242,81,34,125,85,86,187,85,201,136,130,200,166,167,153,225,249,193,88,106,28,213,141,187,231,43,147,166,29,174,242,116,95,5,71,3,104,182,155,39,150,1,113,155,108,156,81,36,96,131,218,141,203,46,104,23,8,123,217,12,114,208,132,107,183,215,225,150,217,228,137,97,88,97,215,30,188,142,104,196,124,163,159,36,59,24,122,108,218,196,162,81,76,237,139,72,109,160,173,204,141,31,173,208,195,156,113,36,17,112,128,54,82,163,116,66,108,53,120,247,161,127,34,181,125,178,197,224,29,31,27,87,133,138,36,142,165,28,107,189,96,36,183,139,138,209,54,149,136,11,45,57,83,212,180,75,185,66,166,193,123,21,231,175,2,127,53,242,180,141,211,13,81,87,114,103,68,213,112,160,211,124,218,223,34,34,254,183,4,32,72,165,240,117,202,44,186,232,47,80,236,178,13,156,209,58,239,198,217,107,253,152,129,93,110,90,34,28,238,28,123,177,232,176,150,143,181,97,72,90,168,53,92,63,43,219,38,24,25,251,252,78,85,68,223,51,24,188,43,135,210,71,7,222,125,35,251,131,183,131,147,230,199,183,73,97,159,85,79,201,218,134,220,190,244,92,71,134,108,2,53,201,251,94,180,38,110,129,204,189,142,186,249,165,26,53,252,141,20,0,249,183,20,187,167,250,252,239,208,72,175,118,67,112,156,200,52,151,37,0,194,5,246,201,234,217,161,53,243,2,142,31,183,171,166,179,70,142,130,98,174,152,4,106,117,218,104,165,26,45,121,34,206,34,239,89,48,195,254,72,184,253,212,160,208,88,232,243,127,18,254,105,35,126,80,153,179,188,247,47,170,110,34,107,243,215,69,54,210,254,120,121,173,23,109,40,20,174,239,89,155,16,138,78,126,39,13,18,185,104,195,173,213,127,14,74,221,22,50,25,197,72,114,90,107,206,1,23,10,210,89,192,209,122,109,112,75,32,209,173,225,64,181,81,243,197,89,139,255,179,74,77,217,217,105,69,206,27,32,27,15,112,238,71,141,22,42,32,25,98,227,201,61,91,115,209,205,230,100,58,52,221,49,79,224,184,184,175,231,136,83,227},
  {129,170,180,173,8,180,120,200,162,54,168,245,73,25,130,136,19,129,168,28,169,144,189,42,104,45,31,220,162,33,249,18,26,77,47,16,34,60,198,136,143,4,11,147,80,131,94,124,33,27,238,254,196,157,130,188,137,30,181,209,105,192,198,244,37,86,124,116,248,10,149,229,20,113,253,190,156,185,138,196,248,175,135,114,114,81,98,26,152,19,148,62,239,102,201,164,67,14,69,87,84,173,96,121,230,93,158,23,95,32,143,76,244,95,251,223,31,106,204,82,113,207,184,197,212,208,237,221,125,231,132,43,54,85,151,184,119,34,76,88,221,26,245,39,217,70,65,67,144,56,104,193,161,40,185,160,126,26,129,191,6,149,46,26,218,12,228,83,231,184,199,181,164,177,46,18,141,232,105,41,12,139,36,231,65,204,150,91,113,90,87,224,37,144,41,19,130,5,89,154,98,152,184,122,183,109,233,245,148,90,223,5,238,172,131,28,160,29,133,197,34,163,57,176,225,20,108,61,113,19,157,222,197,42,221,114,231,72,205,247,205,113,13,20,245,161,222,155,119,217,211,213,120,1,200,197,195,211,84,175,151,106,98,33,159,245,173,64,186,246,120,218,193,192,116,177,88,4,153,196,151,134,232,187,93,190,139,179,35,52,64,83,42,154,170,13,197,125,187,164,180,198,153,93,171,202,7,54,33,231,118,205,31,82,197,134,19,16,186,209,134,245,161,193,185,121,31,5,25,173,85,180,176,211,121,226,31,210,55,141,241,147,13,150,191,33,187,9,39,219,219,161,99,85,180,41,36,44,227,168,3,248,7,216,186,74,99,7,112,56,110,90,43,118,20,173,194,36,73,72,205,54,142,107,199,246,211,5,189,219,30,244,51,103,196,40,122,186,169,61,158,164,88,130,45,12,179,101,65,10,17,185,145,221,31,41,145,114,255,154,91,17,64,255,253,69,115,144,228,27,54,203,16,140,68,168,202,186,114,145,199,90,58,154,40,16,98,232,7,40,89,174,61,108,110,40,138,115,190,104,199,227,165,170,119,237,183,215,9,13,188,198,169,161,145,128,189,39,107,180,209,178,92,62,120,194,116,89,64,187,167,237,169,95,224,243,13,103,3,126,244,18,215,46,51,227,100,230,48,44,191,206,65,216,119,129,45,57,149,71,214,143,255,80,154,25,252,6,160,12,89,87,132,30,206,111,114,63,152,70,221,167,217,223,148,12,231,123,85,158,230,85,62,74,34,242,189,187,70,121,72,3,63,180,82,191,93,107,189,116,128,49,156,115,241,79,75,217,23,125,139,8,104,234,143,220,67,25,135,55,109,12,46,139,24,38,215,171,232,194,239,195,49,228,26,245,5,135,217,161,169,222,12,198,98,87,25,19,247,113,6,45,15,53,7,11,77,66,66,99,146,190,0,214,130,132,100,208,39,120,180,54,144,94,35,116,65,92,29,174,86,123,40,23,104,166,221,107,202,141,98,2,204,197,201,160,28,2,23,20,62,137,159,199,126,32,91,127,56,177,208,80,127,22,15,248,117,79,232,19,185,142,4,150,58,208,162,255,220,39,242,16,246,228,100,21,246,151,7,242,32,0,25,120,35,39,51,141,201,223,239,77,189,70,39,215,196,9,75,142,24,39,133,110,161,245,52,64,43,17,206,73,112,9,1,188,8,216,8,67,69,89,112,166,209,90,9,22,246,195,117,11,198,42,23,108,153,250,224,7,165,173,197,115,116,169,227,182,219,254,246,99,246,134,236,6,156,71,100,133,150,46,126,94,126,74,14,245,168,192,154,234,82,67,57,14,200,189,17,217,251,93,34,105,132,87,192,31,50,105,84,69,57,148,30,10,45,197,12,48,76,97,215,18,185,138,181,72,185,116,21,132,116,124,105,31,69,12,175,242,246,216,223,132,236,189,34,107,145,98,227,217,188,52,166,85,75,119,70,168,141,91,144,144,221,219,214,76,161,196,111,198,74,76,95,8,252,237,132,131,243,74,45,36,142,33,93,30,253,182,86,177,254,164,250,92,173,145,2,202,6,184,163,220,245,129,41,233,151,115,54,192,22,145,203,17,206,172,209,104,195,198,56,36,165,47,116,250,247,52,143,206,111,59,244,19,186,177,140,132,71,134,101,10,20,221,165,208,164,205,131,82,90,47,148,245,136,122,70,157,44,125,123,229,65,13,161,157,148,26,88,11,251,204,62,170,72,104,238,122,223,181,67,23,58,179,50,98,250,231,232,255,74,122,32,32,149,37,111,129,104,175,10,105,113,120,254,201,140,112,64,88,205,180,73,201,188,220,29,15,119,193,134,43,100,42,9,177,123,8,103,146,74,18,107,218,97,80,247,246,201,123,187,194,72,98,161,161,54,31,84,205,66,21,124,176,125,78,153,123,100,59,127,64,118,7,156,38,198,207,123,18,152,140,90,245,231,72,233,56,142,160,127,81,5,61,130,152,122,166,33,149,18,13,133,205,121,156,75,88,206,74,37,105,108,143,17,177,75,158,129,113,20,73,180,156,190,70,217,66,161,65,131,158,218,17,19,122,16,196,179,167,153,55,242,44,102,195,218,113,18,243,184,105,6,22,104,212,103,223,10,171,117,156,209,23,36,200,211,152,205,6,206,7,26,120,9,139,151,240,77,40,92,110,43,98,102,158,204,149,251,18,150,202,71,178,32,226,48,75,3,84,65,124,89,71,218,148,223,210,163,152,86,170,22,87,10,38,53,244,28,83,202,252,59,176,30,237,184,198,62,131,26,75,188,162,146,88,251,217,238,18,22,229,116,92,238,116,241,67,212,79,31,106,199,26,233,54,88,102,208,246,119,124,51,37,146,26,255,196,128,181,156,208,31,106,113,27,111,55,167,57,20,63,211,164,85,250,188,118,54,199,41,76,218,106,27,239,12,199,83,91,147,254,242,35,35,222,73,222,164,240,181,30,197,209,10,52,243,170,199,121,22,41,35,129,209,35,11,81,43,49,154,225,187,134,68,79,87,115,46,46,129,245,111,136,155,181,198,64,165,173,64,128,224,216,113,171,107,26,45,45,243,149,192,138,96,103,70,54,142,118,212,150,17,156,60,168,110,121,12,224,133,211,217,189,222,195,181,118,166,164,183,219,174,141,6,24,138,81,133,176,174,55,110,191,94,154,199,174,148,221,206,8,196,53,220,221,43,21,185,46,32,127,250,96,108,202,51,236,116,7,136,43,32,241,90,186,16,235,130,44,216,106,123,175,0,198,190,51,183,166,150,68,132,82,223,139,211,3,212,106,45,136,159,82,24,127,162,187,155,48,29,2,147,145,40,218,123,211,64,204,130,43,169,248,127,211,34,242,68,91,246,70,102,61,26,111,25,39,44,52,117,4,230,234,137,107,25,170,34,125,125,71,120,210,26,25,23,130,135,213,116,62,4,214,40,161,90,105,246,119,220,97,249,92,60,180,251,243,56,136,170,74,110,93,186,232,97,216,164,67,141,93,249,6,156,127,28,234,134,13,137,235,184,146,74,147,240,157,87,207,183,246,197,112,37,118,108,130,155,181,84,220,124,53,245,231,45,193,76,10,74,131,149,146,33,176,60,246,4,89,8,248,162,196,139,201,43,4,177,50,189,70,24,114,53,169,139,52,193,208,210,235,200,74,254,235,232,217,205,213,254,60,5,19,158,160,91,30,184,73,209,195,94,30,203,170,91,19,150,74,49,234,127,93,124,48,189,150,11,161,204,195,153,0,112,137,229,210,17,242,64,21,240,221,144,186,82,11,127,202,249,51,90,108,246,49,167,153,128,229,181,112,133,115,5,128,114,225,72,129,176,164,144,118,70,253,209,11,201,235,184,196,251,204,152,169,46,116,101,12,216,154,77,51,44,179,152,22,60,196,109,42,155,221,253,114,135,133,246,182,13,157,2,244,51,13,3,57,63,184,171,104,136,18,225,11,36,14,3,61,29,100,17,30,16,161,216,203,138,237,167,78,116,21,202,182,71,235,58,94,130,185,157,237,101,183,47,156,203,228,112,52,136,198,192,208,93,248,93,136,58,176,18,33,57,148,47,27,180,58,23,58,67,164,36,253,108,29,189,35,217,64,7,104,228,213,254,162,96,50,92,179,173,128,109,84,162,16,17,168,43,231,72,77,186,189,81,224,16,115,57,147,163,114,47,1,117,44,155,158,232,240,118,108,69,250,181,218,234,196,74,105,221,229,127,103,248,32,133,70,29,157,224,214,71,68,1,186,205,126,199,184,66,207,179,194,170,250,225,27,37,147,16,218,113,46,198,144,172,10,161,181,252,0,57,75,245,215,255,128,114,88,66,221,166,165,106,214,176,190,5,84,128,211,234,10,92,88,37,146,45,210,121,116,237,69,146,163,228,72,112,178,67,169,241,153,160,40,242,145,172,85,216,65,169,106,239,223,106,132,171,143,32,74,102,9,50,195,63,2,28,184,133,82,42,25,214,252,73,129,155,174,239,39,97,133,5,193,242,56,221,34,140,200,172,6,7,136,241,249,88,87,110,19,122,2,223,182,85,76,167,142,93,25,136,74,171,40,21,56,248,35,135,22,87,104,159,19,153,71,38,39,33,101,85,82,170,126,130,91,158,98,205,158,35,144,79,106,153,106,118,224,203,85,239,238,201,124,14,4,94,188,66,118,204,8,192,0,40,189,119,234,188,201,34,82,84,199,180,53,212,120,29,142,127,181,47,135,16,137,154,117,225,241,151,252,80,218,27,83,193,214,124,139,129,65,181,91,151,227,158,177,240,227,251,72,0,34,26,234,244,67,21,143,208,99,76,60,145,81,32,145,50,181,66,145,223,194,37,85,2,108,119,65,170,116,137,74,74,213,241,42,245,102,109,150,24,37,23,33,74,51,102,194,97,99,158,96,124,15,213,243,25,198,93,88,185,223,25,77,33,62,144,101,119,190,6,107,95,131,176,186,65,34,110,60,156,125,77,154,190,17,148,255,172,191,130,1,180,233,26,7,215,74,203,47,157,145,150,149,210,199,67,121,61,249,194,206,108,65,119,218,234,2,86,200,132,253,197,60,69,127,15,110,193,16,56,249,107,132,190,22,185,233,204,103,119,49,223,154,175,206,198,148,203,121,6,15,124,170,28,148,125,200,132,73,105,191,72,235,211,19,47,99,20,229,51,213,111,56,72,31,66,195,72,37,70,69,126,122,97,81,215,254,183,231,150,183,151,113,161,23,147,103,243,164,21,106,173,64,2,173,209,157,18,67,116,81,36,137,202,193,149,100,110,62,202,220,192,148,183,8,47,241,84,252,170,97,70,114,163,50,26,230,254,200,29,228,138,244,202,2,97,21,109,127,170,89,111,242,58,175,78,181,66,170,116,6,160,239,247,135,35,226,239,122,14,169,234,5,15,59,46,79,219,0,145,29,221,118,109,237,111,33,19,177,5,219,181,193,160,216,143,178,238,53,221,75,178,50,110,117,147,156,135,254,111,60,166,164,21,12,86,117,198,162,155,118,130,33,9,249,52,98,198,238,231,113,37,146,254,159,254,232,124,77,155,22,84,49,27,21,205,56,132,27,23,233,45,225,110,185,181,130,2,95,71,40,82,74,127,7,128,74,101,162,23,155,86,60,147,216,126,148,65,99,113,155,34,149,49,55,217,210,17,249,139,95,75,132,22,77,11,179,190,136,229,14,30,249,34,83,0,180,43,29,25,40,50,76,161,48,5,152,112,230,96,86,14,137,56,83,187,237,68,185,109,248,119,245,227,45,244,92,77,175,74,30,244,144,23,115,175,82,48,190,220,6,212,170,23,131,24,152,58,195,35,16,218,255,138,216,75,59,181,245,31,166,248,69,20,113,199,13,20,83,104,90,33,129,14,236,157,161,154,17,84,106,77,133,110,9,20,211,15,249,231,252,183,100,102,234,121,131,129,201,138,115,152,166,62,167,154,178,209,177,213,4,64,118,165,193,106,216,43,67,11,217,43,13,195,224,239,80,23,97,61,212,189,48,72,172,225,147,209,85,203,46,37,182,147,117,253,105,43,8,216,94,173,23,235,120,112,166,75,91,210,250,123,35,20,100,255,232,74,117,152,42,228,214,167,248,132,84,120,48,194,41,67,61,41,78,15,78,185,151,35,39,204,107,33,221,83,146,167,161,41,95,244,249,31,169,76,73,149,67,56,175,252,196,66,161,61,176,201,204,7,136,24,242,141,97,115,220,215,26,6,125,23,101,122,4,136,143,77,44,146,96,108,66,36,100,59,252,204,126,163,107,24,247,57,232,41,151,4,217,179,216,126,67,163,143,178,213,68,226,114,208,156,153,176,254,204,130,191,201,203,136,240,112,72,25,170,105,229,136,168,158,68,155,161,174,63,81,231,250,119,182,242,172,228,119,84,14,204,167,151,64,185,21,51,78,138,197,53,103,219,12,12,131,243,190,202,111,181,184,85,45,13,87,174,227,231,201,228,229,198,183,34,102,158,2,145,121,27,185,51,144,119,133,199,205,190,16,54,200,157,117,25,121,204,6,218,240,148,110,107,201,220,236,50,246,154,21,226,219,235,79,1,73,172,125,239,44,123,204,98,226,213,28,160,208,135,114,76,47,190,148,173,208,114,88,136,220,22,206,26,22,53,72,184,235,162,18,248,2,240,46,252,1,58,220,224,26,208,54,65,152,207,39,58,30,249,7,202,65,152,196,179,27,132,82,129,173,205,50,7,74,122,117,13,34,143,89,17,239,9,252,180,198,122,200,106,127,245,35,11,220,139,4,237,15,76,9,118,161,33,37,208,84,93,15,243,129,131,138,15,180,241,220,67,56,108,141,255,1,249,208,138,221,214,207,44,149,24,50,170,150,53,62,6,225,53,3,226,100,55,178,175,94,27,142,149,61,143,154,94,254,122,158,213,174,123,42,80,46,204,116,238,242,116,205,144,10,145,220,183,182,184,124,91,109,230,218,54,143,104,216,128,144,158,189,131,3,3,151,112,49,182,115,177,15,145,83,32,238,6,88,118,61,126,165,18,191,217,138,198,116,237,253,53,167,138,244,182,24,155,184,231,29,189,202,156,227,26,243,253,158,147,62,128,55,43,253,248,242,144,52,154,139,12,121,97,105,112,249,77,32,240,110,89,14,233,87,171,40,99,134,151,120,40,158,72,63,35,93,113,134,146,101,238,239,86,220,59,73,49,131,37,97,128,209,51,136,42,10,68,90,214,173,153,55,114,78,220,180,15,234,212,241,235,70,121,192,172,67,0,91,67,232,21,153,63,113,168,57,59,5,7,226,41,26,27,68,50,228,63,247,82,245,243,38,78,218,165,164,165,202,153,94,21,253,162,187,66,131,82,53,85,234,47,80,247,22,135,14,23,196,84,107,230,32,90,21,42,48,255,135,147,182,46,114,187,64,242,156,1,238,109,148,179,38,223,131,46,123,126,252,69,132,102,152,59,66,158,128,241,241,194,146,63,177,52,181,26,134,99,226,156,138,186,107,159,218,247,236,56,142,193,46,138,98,128,218,247,166,231,85,46,86,72,190,204,147,226,177,202,189,100,57,178,92,190,92,26,249,103,167,175,75,206,119,85,135,89,251,106,21,196,50,85,62,165,34,129,12,220,126,187,72,87,100,231,53,25,127,35,36,85,116,148,21,84,11,234,59,164,71,145,22,191,213,164,6,16,58,159,208,105,147,41,85,185,157,142,115},
} ;

static void test_decode_857xint32_impl(long long impl)
{
  unsigned char *x = test_decode_857xint32_x;
  unsigned char *s = test_decode_857xint32_s;
  unsigned char *x2 = test_decode_857xint32_x2;
  unsigned char *s2 = test_decode_857xint32_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_857xint32_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_857xint32(impl);
    printf("decode_857xint32 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_857xint32_implementation(impl),ntruprime_dispatch_decode_857xint32_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_857xint32;
    printf("decode_857xint32 selected implementation %s compiler %s\n",ntruprime_decode_857xint32_implementation(),ntruprime_decode_857xint32_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_857xint32_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_857xint32_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_857xint32_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_857xint32_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_857xint32_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_857xint32_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_857xint32(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"857xint32")) return;
  storage_decode_857xint32_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_857xint32_x = aligned(storage_decode_857xint32_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_857xint32_s = callocplus(crypto_decode_STRBYTES);
  test_decode_857xint32_s = aligned(storage_decode_857xint32_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_857xint32_x2 = callocplus(maxalloc);
  test_decode_857xint32_x2 = aligned(storage_decode_857xint32_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_857xint32_s2 = callocplus(maxalloc);
  test_decode_857xint32_s2 = aligned(storage_decode_857xint32_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_857xint32 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_857xint32();++impl)
      forked(test_decode_857xint32_impl,impl);
    ++test_decode_857xint32_x;
    ++test_decode_857xint32_s;
    ++test_decode_857xint32_x2;
    ++test_decode_857xint32_s2;
  }
  free(storage_decode_857xint32_s2);
  free(storage_decode_857xint32_x2);
  free(storage_decode_857xint32_s);
  free(storage_decode_857xint32_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

