; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -mtriple=thumbv8m.main %s -passes=simplifycfg -simplifycfg-require-and-preserve-domtree=1 -S | FileCheck %s --check-prefix=CHECK --check-prefix=THUMB
; RUN: opt -mtriple=thumbv8a %s -passes=simplifycfg -simplifycfg-require-and-preserve-domtree=1 -S | FileCheck %s --check-prefix=CHECK --check-prefix=THUMB
; RUN: opt -mtriple=armv8a %s -passes=simplifycfg -simplifycfg-require-and-preserve-domtree=1 -S | FileCheck %s --check-prefix=CHECK --check-prefix=ARM

define i32 @foo(i32 %a, i32 %b, i32 %c, i32 %d, ptr %input) {
; CHECK-LABEL: @foo(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sle i32 [[D:%.*]], 3
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[C:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[ADD]], [[B:%.*]]
; CHECK-NEXT:    [[OR_COND:%.*]] = select i1 [[CMP]], i1 [[CMP1]], i1 false
; CHECK-NEXT:    br i1 [[OR_COND]], label [[COND_FALSE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.false:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[INPUT:%.*]], align 4
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP0]], [[COND_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  %cmp = icmp sgt i32 %d, 3
  br i1 %cmp, label %cond.end, label %lor.lhs.false

lor.lhs.false:
  %add = add nsw i32 %c, %a
  %cmp1 = icmp slt i32 %add, %b
  br i1 %cmp1, label %cond.false, label %cond.end

cond.false:
  %0 = load i32, ptr %input, align 4
  br label %cond.end

cond.end:
  %cond = phi i32 [ %0, %cond.false ], [ 0, %lor.lhs.false ], [ 0, %entry ]
  ret i32 %cond
}

define i32 @foo_minsize(i32 %a, i32 %b, i32 %c, i32 %d, ptr %input) #0 {
; CHECK-LABEL: @foo_minsize(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sle i32 [[D:%.*]], 3
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[C:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[ADD]], [[B:%.*]]
; CHECK-NEXT:    [[OR_COND:%.*]] = select i1 [[CMP]], i1 [[CMP1]], i1 false
; CHECK-NEXT:    br i1 [[OR_COND]], label [[COND_FALSE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.false:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[INPUT:%.*]], align 4
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP0]], [[COND_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  %cmp = icmp sgt i32 %d, 3
  br i1 %cmp, label %cond.end, label %lor.lhs.false

lor.lhs.false:
  %add = add nsw i32 %c, %a
  %cmp1 = icmp slt i32 %add, %b
  br i1 %cmp1, label %cond.false, label %cond.end

cond.false:
  %0 = load i32, ptr %input, align 4
  br label %cond.end

cond.end:
  %cond = phi i32 [ %0, %cond.false ], [ 0, %lor.lhs.false ], [ 0, %entry ]
  ret i32 %cond
}

define i32 @foo_minsize_i64(i64 %a, i64 %b, i64 %c, i64 %d, ptr %input) #0 {
; CHECK-LABEL: @foo_minsize_i64(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sle i64 [[D:%.*]], 3
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[C:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i64 [[ADD]], [[B:%.*]]
; CHECK-NEXT:    [[OR_COND:%.*]] = select i1 [[CMP]], i1 [[CMP1]], i1 false
; CHECK-NEXT:    br i1 [[OR_COND]], label [[COND_FALSE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.false:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[INPUT:%.*]], align 4
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP0]], [[COND_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  %cmp = icmp sgt i64 %d, 3
  br i1 %cmp, label %cond.end, label %lor.lhs.false

lor.lhs.false:
  %add = add nsw i64 %c, %a
  %cmp1 = icmp slt i64 %add, %b
  br i1 %cmp1, label %cond.false, label %cond.end

cond.false:
  %0 = load i32, ptr %input, align 4
  br label %cond.end

cond.end:
  %cond = phi i32 [ %0, %cond.false ], [ 0, %lor.lhs.false ], [ 0, %entry ]
  ret i32 %cond
}

define i32 @or_predicate(i32 %a, i32 %b, i32 %c, i32 %d, ptr %input) {
; CHECK-LABEL: @or_predicate(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[D:%.*]], 3
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[C:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[ADD]], [[B:%.*]]
; CHECK-NEXT:    [[OR_COND:%.*]] = select i1 [[CMP]], i1 true, i1 [[CMP1]]
; CHECK-NEXT:    br i1 [[OR_COND]], label [[COND_END:%.*]], label [[COND_FALSE:%.*]]
; CHECK:       cond.false:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[INPUT:%.*]], align 4
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP0]], [[COND_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  %cmp = icmp sgt i32 %d, 3
  br i1 %cmp, label %cond.end, label %lor.lhs.false

lor.lhs.false:
  %add = add nsw i32 %c, %a
  %cmp1 = icmp slt i32 %add, %b
  br i1 %cmp1, label %cond.end, label %cond.false

cond.false:
  %0 = load i32, ptr %input, align 4
  br label %cond.end

cond.end:
  %cond = phi i32 [ %0, %cond.false ], [ 0, %lor.lhs.false ], [ 0, %entry ]
  ret i32 %cond
}

define i32 @or_invert_predicate(i32 %a, i32 %b, i32 %c, i32 %d, ptr %input) {
; CHECK-LABEL: @or_invert_predicate(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sle i32 [[D:%.*]], 3
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[C:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[ADD]], [[B:%.*]]
; CHECK-NEXT:    [[OR_COND:%.*]] = select i1 [[CMP]], i1 true, i1 [[CMP1]]
; CHECK-NEXT:    br i1 [[OR_COND]], label [[COND_END:%.*]], label [[COND_FALSE:%.*]]
; CHECK:       cond.false:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[INPUT:%.*]], align 4
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP0]], [[COND_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  %cmp = icmp sgt i32 %d, 3
  br i1 %cmp, label %lor.lhs.false, label %cond.end

lor.lhs.false:
  %add = add nsw i32 %c, %a
  %cmp1 = icmp slt i32 %add, %b
  br i1 %cmp1, label %cond.end, label %cond.false

cond.false:
  %0 = load i32, ptr %input, align 4
  br label %cond.end

cond.end:
  %cond = phi i32 [ %0, %cond.false ], [ 0, %lor.lhs.false ], [ 0, %entry ]
  ret i32 %cond
}

define i32 @or_predicate_minsize(i32 %a, i32 %b, i32 %c, i32 %d, ptr %input) #0 {
; THUMB-LABEL: @or_predicate_minsize(
; THUMB-NEXT:  entry:
; THUMB-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[D:%.*]], 3
; THUMB-NEXT:    br i1 [[CMP]], label [[COND_END:%.*]], label [[LOR_LHS_FALSE:%.*]]
; THUMB:       lor.lhs.false:
; THUMB-NEXT:    [[ADD:%.*]] = add nsw i32 [[C:%.*]], [[A:%.*]]
; THUMB-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[ADD]], [[B:%.*]]
; THUMB-NEXT:    br i1 [[CMP1]], label [[COND_END]], label [[COND_FALSE:%.*]]
; THUMB:       cond.false:
; THUMB-NEXT:    [[TMP0:%.*]] = load i32, ptr [[INPUT:%.*]], align 4
; THUMB-NEXT:    br label [[COND_END]]
; THUMB:       cond.end:
; THUMB-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP0]], [[COND_FALSE]] ], [ 0, [[LOR_LHS_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; THUMB-NEXT:    ret i32 [[COND]]
;
; ARM-LABEL: @or_predicate_minsize(
; ARM-NEXT:  entry:
; ARM-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[D:%.*]], 3
; ARM-NEXT:    [[ADD:%.*]] = add nsw i32 [[C:%.*]], [[A:%.*]]
; ARM-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[ADD]], [[B:%.*]]
; ARM-NEXT:    [[OR_COND:%.*]] = select i1 [[CMP]], i1 true, i1 [[CMP1]]
; ARM-NEXT:    br i1 [[OR_COND]], label [[COND_END:%.*]], label [[COND_FALSE:%.*]]
; ARM:       cond.false:
; ARM-NEXT:    [[TMP0:%.*]] = load i32, ptr [[INPUT:%.*]], align 4
; ARM-NEXT:    br label [[COND_END]]
; ARM:       cond.end:
; ARM-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP0]], [[COND_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; ARM-NEXT:    ret i32 [[COND]]
;
entry:
  %cmp = icmp sgt i32 %d, 3
  br i1 %cmp, label %cond.end, label %lor.lhs.false

lor.lhs.false:
  %add = add nsw i32 %c, %a
  %cmp1 = icmp slt i32 %add, %b
  br i1 %cmp1, label %cond.end, label %cond.false

cond.false:
  %0 = load i32, ptr %input, align 4
  br label %cond.end

cond.end:
  %cond = phi i32 [ %0, %cond.false ], [ 0, %lor.lhs.false ], [ 0, %entry ]
  ret i32 %cond
}

define i32 @or_invert_predicate_minsize(i32 %a, i32 %b, i32 %c, i32 %d, ptr %input) #0 {
; THUMB-LABEL: @or_invert_predicate_minsize(
; THUMB-NEXT:  entry:
; THUMB-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[D:%.*]], 3
; THUMB-NEXT:    br i1 [[CMP]], label [[LOR_LHS_FALSE:%.*]], label [[COND_END:%.*]]
; THUMB:       lor.lhs.false:
; THUMB-NEXT:    [[ADD:%.*]] = add nsw i32 [[C:%.*]], [[A:%.*]]
; THUMB-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[ADD]], [[B:%.*]]
; THUMB-NEXT:    br i1 [[CMP1]], label [[COND_END]], label [[COND_FALSE:%.*]]
; THUMB:       cond.false:
; THUMB-NEXT:    [[TMP0:%.*]] = load i32, ptr [[INPUT:%.*]], align 4
; THUMB-NEXT:    br label [[COND_END]]
; THUMB:       cond.end:
; THUMB-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP0]], [[COND_FALSE]] ], [ 0, [[LOR_LHS_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; THUMB-NEXT:    ret i32 [[COND]]
;
; ARM-LABEL: @or_invert_predicate_minsize(
; ARM-NEXT:  entry:
; ARM-NEXT:    [[CMP:%.*]] = icmp sle i32 [[D:%.*]], 3
; ARM-NEXT:    [[ADD:%.*]] = add nsw i32 [[C:%.*]], [[A:%.*]]
; ARM-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[ADD]], [[B:%.*]]
; ARM-NEXT:    [[OR_COND:%.*]] = select i1 [[CMP]], i1 true, i1 [[CMP1]]
; ARM-NEXT:    br i1 [[OR_COND]], label [[COND_END:%.*]], label [[COND_FALSE:%.*]]
; ARM:       cond.false:
; ARM-NEXT:    [[TMP0:%.*]] = load i32, ptr [[INPUT:%.*]], align 4
; ARM-NEXT:    br label [[COND_END]]
; ARM:       cond.end:
; ARM-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP0]], [[COND_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; ARM-NEXT:    ret i32 [[COND]]
;
entry:
  %cmp = icmp sgt i32 %d, 3
  br i1 %cmp, label %lor.lhs.false, label %cond.end

lor.lhs.false:
  %add = add nsw i32 %c, %a
  %cmp1 = icmp slt i32 %add, %b
  br i1 %cmp1, label %cond.end, label %cond.false

cond.false:
  %0 = load i32, ptr %input, align 4
  br label %cond.end

cond.end:
  %cond = phi i32 [ %0, %cond.false ], [ 0, %lor.lhs.false ], [ 0, %entry ]
  ret i32 %cond
}

define i32 @or_xor_predicate(i32 %a, i32 %b, i32 %c, i32 %d, ptr %input, i1 %cmp) {
; CHECK-LABEL: @or_xor_predicate(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP_NOT:%.*]] = xor i1 [[CMP:%.*]], true
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[C:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[ADD]], [[B:%.*]]
; CHECK-NEXT:    [[OR_COND:%.*]] = select i1 [[CMP_NOT]], i1 true, i1 [[CMP1]]
; CHECK-NEXT:    br i1 [[OR_COND]], label [[COND_END:%.*]], label [[COND_FALSE:%.*]]
; CHECK:       cond.false:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[INPUT:%.*]], align 4
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP0]], [[COND_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  br i1 %cmp, label %lor.lhs.false, label %cond.end

lor.lhs.false:
  %add = add nsw i32 %c, %a
  %cmp1 = icmp slt i32 %add, %b
  br i1 %cmp1, label %cond.end, label %cond.false

cond.false:
  %0 = load i32, ptr %input, align 4
  br label %cond.end

cond.end:
  %cond = phi i32 [ %0, %cond.false ], [ 0, %lor.lhs.false ], [ 0, %entry ]
  ret i32 %cond
}

define i32 @or_xor_predicate_minsize(i32 %a, i32 %b, i32 %c, i32 %d, ptr %input, i1 %cmp) #0 {
; THUMB-LABEL: @or_xor_predicate_minsize(
; THUMB-NEXT:  entry:
; THUMB-NEXT:    br i1 [[CMP:%.*]], label [[LOR_LHS_FALSE:%.*]], label [[COND_END:%.*]]
; THUMB:       lor.lhs.false:
; THUMB-NEXT:    [[ADD:%.*]] = add nsw i32 [[C:%.*]], [[A:%.*]]
; THUMB-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[ADD]], [[B:%.*]]
; THUMB-NEXT:    br i1 [[CMP1]], label [[COND_END]], label [[COND_FALSE:%.*]]
; THUMB:       cond.false:
; THUMB-NEXT:    [[TMP0:%.*]] = load i32, ptr [[INPUT:%.*]], align 4
; THUMB-NEXT:    br label [[COND_END]]
; THUMB:       cond.end:
; THUMB-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP0]], [[COND_FALSE]] ], [ 0, [[LOR_LHS_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; THUMB-NEXT:    ret i32 [[COND]]
;
; ARM-LABEL: @or_xor_predicate_minsize(
; ARM-NEXT:  entry:
; ARM-NEXT:    [[CMP_NOT:%.*]] = xor i1 [[CMP:%.*]], true
; ARM-NEXT:    [[ADD:%.*]] = add nsw i32 [[C:%.*]], [[A:%.*]]
; ARM-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[ADD]], [[B:%.*]]
; ARM-NEXT:    [[OR_COND:%.*]] = select i1 [[CMP_NOT]], i1 true, i1 [[CMP1]]
; ARM-NEXT:    br i1 [[OR_COND]], label [[COND_END:%.*]], label [[COND_FALSE:%.*]]
; ARM:       cond.false:
; ARM-NEXT:    [[TMP0:%.*]] = load i32, ptr [[INPUT:%.*]], align 4
; ARM-NEXT:    br label [[COND_END]]
; ARM:       cond.end:
; ARM-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP0]], [[COND_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; ARM-NEXT:    ret i32 [[COND]]
;
entry:
  br i1 %cmp, label %lor.lhs.false, label %cond.end

lor.lhs.false:
  %add = add nsw i32 %c, %a
  %cmp1 = icmp slt i32 %add, %b
  br i1 %cmp1, label %cond.end, label %cond.false

cond.false:
  %0 = load i32, ptr %input, align 4
  br label %cond.end

cond.end:
  %cond = phi i32 [ %0, %cond.false ], [ 0, %lor.lhs.false ], [ 0, %entry ]
  ret i32 %cond
}

define i32 @and_xor(i32 %a, i32 %b, i32 %c, i32 %d, ptr %input, i1 %cmp) {
; CHECK-LABEL: @and_xor(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP_NOT:%.*]] = xor i1 [[CMP:%.*]], true
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[C:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[ADD]], [[B:%.*]]
; CHECK-NEXT:    [[OR_COND:%.*]] = select i1 [[CMP_NOT]], i1 [[CMP1]], i1 false
; CHECK-NEXT:    br i1 [[OR_COND]], label [[COND_FALSE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.false:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[INPUT:%.*]], align 4
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP0]], [[COND_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[COND]]
;
entry:
  br i1 %cmp, label %cond.end, label %lor.lhs.false

lor.lhs.false:
  %add = add nsw i32 %c, %a
  %cmp1 = icmp slt i32 %add, %b
  br i1 %cmp1, label %cond.false, label %cond.end

cond.false:
  %0 = load i32, ptr %input, align 4
  br label %cond.end

cond.end:
  %cond = phi i32 [ %0, %cond.false ], [ 0, %lor.lhs.false ], [ 0, %entry ]
  ret i32 %cond
}

define i32 @and_xor_minsize(i32 %a, i32 %b, i32 %c, i32 %d, ptr %input, i1 %cmp) #0 {
; THUMB-LABEL: @and_xor_minsize(
; THUMB-NEXT:  entry:
; THUMB-NEXT:    br i1 [[CMP:%.*]], label [[COND_END:%.*]], label [[LOR_LHS_FALSE:%.*]]
; THUMB:       lor.lhs.false:
; THUMB-NEXT:    [[ADD:%.*]] = add nsw i32 [[C:%.*]], [[A:%.*]]
; THUMB-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[ADD]], [[B:%.*]]
; THUMB-NEXT:    br i1 [[CMP1]], label [[COND_FALSE:%.*]], label [[COND_END]]
; THUMB:       cond.false:
; THUMB-NEXT:    [[TMP0:%.*]] = load i32, ptr [[INPUT:%.*]], align 4
; THUMB-NEXT:    br label [[COND_END]]
; THUMB:       cond.end:
; THUMB-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP0]], [[COND_FALSE]] ], [ 0, [[LOR_LHS_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; THUMB-NEXT:    ret i32 [[COND]]
;
; ARM-LABEL: @and_xor_minsize(
; ARM-NEXT:  entry:
; ARM-NEXT:    [[CMP_NOT:%.*]] = xor i1 [[CMP:%.*]], true
; ARM-NEXT:    [[ADD:%.*]] = add nsw i32 [[C:%.*]], [[A:%.*]]
; ARM-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[ADD]], [[B:%.*]]
; ARM-NEXT:    [[OR_COND:%.*]] = select i1 [[CMP_NOT]], i1 [[CMP1]], i1 false
; ARM-NEXT:    br i1 [[OR_COND]], label [[COND_FALSE:%.*]], label [[COND_END:%.*]]
; ARM:       cond.false:
; ARM-NEXT:    [[TMP0:%.*]] = load i32, ptr [[INPUT:%.*]], align 4
; ARM-NEXT:    br label [[COND_END]]
; ARM:       cond.end:
; ARM-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP0]], [[COND_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; ARM-NEXT:    ret i32 [[COND]]
;
entry:
  br i1 %cmp, label %cond.end, label %lor.lhs.false

lor.lhs.false:
  %add = add nsw i32 %c, %a
  %cmp1 = icmp slt i32 %add, %b
  br i1 %cmp1, label %cond.false, label %cond.end

cond.false:
  %0 = load i32, ptr %input, align 4
  br label %cond.end

cond.end:
  %cond = phi i32 [ %0, %cond.false ], [ 0, %lor.lhs.false ], [ 0, %entry ]
  ret i32 %cond
}

attributes #0 = { minsize optsize }
