/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   lcmaps_utils.h
    \brief  API for the utilities for the LCMAPS
    \author Martijn Steenbakkers for the EU DataGrid.

    This header contains the declarations of the LCMAPS utility functions:
    -# lcmaps_genfilename(): 
    -# lcmaps_getfexist():
    -# lcmaps_findfile():
    -# lcmaps_get_gidlist():
    \ingroup APIforLcmapsPlugins
*/

#ifndef LCMAPS_UTILS_H
#define LCMAPS_UTILS_H

/******************************************************************************
                             Include header files
******************************************************************************/
#include <grp.h>
#include <sys/types.h>

/******************************************************************************
 *                 Module definition
 *****************************************************************************/

/*! \name FILENAME FUNCTIONS */
/*@{*/ /* Beginning of filename functions */
/******************************************************************************
Function:       lcmaps_genfilename() (copied from GLOBUS gatekeeper.c)
Description:    generate an absolute file name given a starting prefix,
                a relative or absolute path, and a suffix
                Only use prefix if path is relative.
Parameters:
Returns:        a pointer to a string which could be freeded.
******************************************************************************/
extern char * lcmaps_genfilename(
        const char * prefix,
        const char * path,
        const char * suffix
);

/******************************************************************************
Function:       lcmaps_getfexist()
Description:    picks the first existing file in argument list
Parameters:     n   : number of paths,
                ... : list of paths
Returns:        returns filename found or NULL
******************************************************************************/
extern char * lcmaps_getfexist(
        int n,
        ...
);

/******************************************************************************
Function:       lcmaps_findfile()
Description:    Checks for file in standard directories
Parameters:     name
Returns:        returns filename found (should be freeed) or NULL
******************************************************************************/
extern char * lcmaps_findfile(
        char * name
);
/*@}*/ /* End of filename functions */

/******************************************************************************
Function:   lcmaps_get_gidlist()

Description:
    Finds the list of gids for user in the group file (/etc/group)
    Returns a list of gid_t which should be freed by calling program.

Parameters:
    username:   the name of the user
    ngroups:    ptr to int which will be filled with the number of gids.
    group_list: ptr to an array of gid_t.

Returns:
    0 on success. 
    -1 on realloc failure
    -2 on getgrent failure
    1 on failure
******************************************************************************/
extern int lcmaps_get_gidlist(
        const char * username,
        int * ngroups,
        gid_t ** group_list
);

#endif /* LCMAPS_UTILS_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcmaps/interface/lcmaps_utils.h,v $
    $Date: 2014-02-25 16:11:54 +0100 (Tue, 25 Feb 2014) $
    $Revision: 17511 $
    $Author: msalle $
******************************************************************************/
