#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core import debug

settings_data = {
    "sound": {
        "enabled": True,
        "driver": "genericDriver",
        "theme": "default",
        "volume": 1.0,
        "genericPlayFileCommand": "play -q -v fenrirVolume fenrirSoundFile",
        "genericFrequencyCommand": "play -q -v fenrirVolume -n -c1 synth fenrirDuration sine fenrirFrequence",
    },
    "speech": {
        "enabled": True,
        "driver": "genericDriver",
        "serverPath": "",
        "rate": 0.75,
        "pitch": 0.5,
        "capitalPitch": 0.8,
        "volume": 1.0,
        "module": "",
        "voice": "en-us",
        "language": "",
        "autoReadIncoming": True,
        "readNumbersAsDigits": False,
        "genericSpeechCommand": 'espeak -a fenrirVolume -s fenrirRate -p fenrirPitch -v fenrirVoice "fenrirText"',
        "fenrirMinVolume": 0,
        "fenrirMaxVolume": 200,
        "fenrirMinPitch": 0,
        "fenrirMaxPitch": 99,
        "fenrirMinRate": 80,
        "fenrirMaxRate": 450,
    },
    "screen": {
        "driver": "vcsaDriver",
        "encoding": "auto",
        "screenUpdateDelay": 0.1,
        "ignoreScreen": "",
        "autodetectIgnoreScreen": False,
    },
    "general": {
        "debug_level": debug.DebugLevel.DEACTIVE,
        "debug_mode": "FILE",
        "debugFile": "",
        "punctuationProfile": "default",
        "punctuationLevel": "some",
        "respectPunctuationPause": True,
        "replaceUndefinedPunctuationWithSpace": True,
        "newLinePause": True,
        "numberOfClipboards": 10,
        "emoticons": True,
        "fenrirKeys": "KEY_KP0,KEY_META",
        "scriptKeys": "KEY_COMPOSE",
        "time_format": "%I:%M%P",
        "date_format": "%A, %B %d, %Y",
        "autoSpellCheck": False,
        "spellCheckLanguage": "en_US",
        "script_path": "/usr/share/fenrirscreenreader/scripts",
        "command_path": "/usr/share/fenrirscreenreader/commands",
        "attribute_format_string": "Background fenrirBGColor,Foreground fenrirFGColor,fenrirUnderline,fenrirBold,fenrirBlink, Font fenrirFont,Fontsize fenrirFontSize",
        "autoPresentIndent": False,
        "autoPresentIndentMode": 1,
        "has_attributes": True,
        "shell": "",
    },
    "focus": {
        "cursor": True,
        "highlight": False,
    },
    "remote": {
        "enabled": True,
        "driver": "unixDriver",
        "port": 22447,
        "socket_file": "",
        "enableSettingsRemote": True,
        "enableCommandRemote": True,
    },
    "barrier": {
        "enabled": True,
        "left_barriers": "│└┌─",
        "right_barriers": "│┘┐─",
    },
    "review": {
        "line_break": True,
        "end_of_screen": True,
        "leaveReviewOnCursorChange": True,
        "leaveReviewOnScreenChange": True,
    },
    "menu": {
        "vmenuPath": "",
        "quickMenu": "speech#rate;speech#pitch;speech#volume",
    },
    "promote": {
        "enabled": True,
        "inactiveTimeoutSec": 120,
        "list": "",
    },
    "time": {
        "enabled": False,
        "present_time": True,
        "present_date": True,
        "delay_sec": 0,
        "on_minutes": "00,30",
        "announce": True,
        "interrupt": False,
    },
    "keyboard": {
        "driver": "evdev",
        "device": "all",
        "grabDevices": True,
        "ignoreShortcuts": False,
        "keyboardLayout": "desktop",
        "charEchoMode": 2,  # while capslock
        "charDeleteEcho": True,
        "wordEcho": True,
        "interruptOnKeyPress": True,
        "interruptOnKeyPressFilter": "",
        "doubleTapTimeout": 0.2,
    },
}
