<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version = '1.0' 
     xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<!-- colour.xsl DJCM 2004 -->

<xsl:output method="html" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"
doctype-public="-//W3C//DTD HTML 4.01//EN"
doctype-system="http://www.w3.org/TR/html4/strict.dtd" />


<xsl:template match="colours">
<html lang="en">
<head>
<title>Dasher Colour Schemes</title>
<!-- Uncomment the following line if your xslt processor doesn't add it.
     xsltproc from the Gnome project (and available for Windows) does. -->
<!-- <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /> -->
<link rel="home" title="Home" href="http://www.inference.phy.cam.ac.uk/dasher/"/>
<link rel="contact" title="Contact" href="http://www.metafaq.com/faq/dasher/"/>
<style type="text/css">
.content {font-family : 'Lucida Grande', Verdana, Geneva, Lucida, Arial, Helvetica, sans-serif;}
.content h1 {border-bottom : 2px solid #4686c2; margin-bottom : 1em;}
.content h2 {margin-top : 0;}
.content hr{
	color : #4686c2;
	background-color : #4686c2;
	height : 2px;
	border: 0 solid #4686c2;
	margin-top : 1em;
	margin-bottom : 1em;
}
</style>
</head>
<body>
<div class="content">
	<h1><a><xsl:attribute name="href">http://www.inference.phy.cam.ac.uk/dasher/</xsl:attribute>Dasher </a>
<a><xsl:attribute name="href">http://www.inference.phy.cam.ac.uk/dasher/download/alphabets/</xsl:attribute>Alphabets</a></h1>
	<xsl:apply-templates select="//palette"/>
</div>

<div style="text-align:right"><em>This page automagically generated by
<a><xsl:attribute name="href">http://www.inference.phy.cam.ac.uk/dasher/download/alphabets/colour.xsl</xsl:attribute>
colour.xsl
</a></em></div>

</body>
</html> 
</xsl:template>

<xsl:variable name="hex" >0123456789ABCDEF</xsl:variable>
<xsl:variable name="col" >0</xsl:variable>

<xsl:template match="palette">
<h2><xsl:value-of select="@name"/></h2>
	<table bgcolor="#888888"><tr><td>
	<table bgcolor="#bbbbbb">
  <xsl:for-each select="colour">	<tr bgcolor="#ffffee">
<td><xsl:number value="position()-1"></xsl:number> </td>
        <td><xsl:value-of select="@r"/>
        </td>
	<td><xsl:value-of select="@g"/></td>
	<td><xsl:value-of select="@b"/></td>	
  <td>  <xsl:call-template name="hexify">
        <xsl:with-param name="str" select="@r"/>
        </xsl:call-template>
        <xsl:call-template name="hexify">
          <xsl:with-param name="str" select="@g"/>
        </xsl:call-template>
        <xsl:call-template name="hexify">
          <xsl:with-param name="str" select="@b"/>
        </xsl:call-template>
</td>
<td>
  <xsl:attribute name="bgcolor">
 #<xsl:call-template name="hexify">
        <xsl:with-param name="str" select="@r"/>
        </xsl:call-template>
        <xsl:call-template name="hexify">
          <xsl:with-param name="str" select="@g"/>
        </xsl:call-template>
        <xsl:call-template name="hexify">
          <xsl:with-param name="str" select="@b"/>
        </xsl:call-template>
  </xsl:attribute>
 <xsl:call-template name="hexify">
        <xsl:with-param name="str" select="@r"/>
        </xsl:call-template>
        <xsl:call-template name="hexify">
          <xsl:with-param name="str" select="@g"/>
        </xsl:call-template>
        <xsl:call-template name="hexify">
          <xsl:with-param name="str" select="@b"/>
        </xsl:call-template>
</td>
</tr>
  </xsl:for-each>
	</table></td></tr></table>
	<hr/>
</xsl:template>


  <xsl:template name="hexify">
    <xsl:param name="str"/>   
      <xsl:variable name="hex-digit1" select="substring($hex,floor($str div 16) + 1,1)"/>
      <xsl:variable name="hex-digit2" select="substring($hex,$str mod 16 + 1,1)"/>
      <xsl:value-of select="concat($hex-digit1,$hex-digit2)"/>
  </xsl:template>

</xsl:stylesheet>

