import org.checkerframework.checker.index.qual.*;

class ConstantArrays {
    void basic_test() {
        int[] b = new int[4];
        @LTLengthOf("b") int[] a = {0, 1, 2, 3};

        // :: error: (array.initializer.type.incompatible)::error: (assignment.type.incompatible)
        @LTLengthOf("b") int[] a1 = {0, 1, 2, 4};

        @LTEqLengthOf("b") int[] c = {-1, 4, 3, 1};

        // :: error: (array.initializer.type.incompatible)::error: (assignment.type.incompatible)
        @LTEqLengthOf("b") int[] c2 = {-1, 4, 5, 1};
    }

    void offset_test() {
        int[] b = new int[4];
        int[] b2 = new int[10];
        @LTLengthOf(
                value = {"b", "b2"},
                offset = {"-2", "5"})
        int[] a = {2, 3, 0};

        @LTLengthOf(
                value = {"b", "b2"},
                offset = {"-2", "5"})
        // :: error: (array.initializer.type.incompatible)::error: (assignment.type.incompatible)
        int[] a2 = {2, 3, 5};

        // Non-constant offsets don't work correctly. See kelloggm#120.
    }
}
