/**
 * Creates the U.F.O. object in obv format as required by our Vlib.
 * Basically a cone with 8 round "shields" (or laser beam thrower, or whatever
 * they are) all around, 4 red to the right, 4 green to the left.
 * Sends its output to stdout, so one has to redirect it to
 * ../objects/aircraft/ufo.obv by hand.
 * 
 * @file
 * @author Umberto Salsi <salsi@icosaedro.it>
 * @version $Date: 2017/10/30 02:17:57 $
 */

/*
 * LINKER_OPTIONS -lm
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "../src/V/Vlibmath.h"
//#include "../src/V/VObjects.h"

// Height (ft):
#define H (20.0)

// Base radius:
#define R (1.1*H)

// Shields' radius:
#define S (0.25*H)

static int no_of_points;
static int no_of_polygons;
static char this_polygon_color[100];
static int this_polygon_no_vertices;
static char this_polygon_vertices[2000];
static char points[2000];
static char polygons[2000];


static void openPolygon(char *colors)
{
	strcpy(this_polygon_color, colors);
	this_polygon_no_vertices = 0;
	strcpy(this_polygon_vertices, "");
}


static void addPoint(VPoint *p)
{
	char s[100];
	
	no_of_points++;
	
	sprintf(s, "%d %.2f %.2f %.2f\n", no_of_points, p->x, p->y, p->z);
	strcat(points, s);
	
	sprintf(s, " %d", no_of_points);
	strcat(this_polygon_vertices, s);
	this_polygon_no_vertices++;
}


static void closePolygon()
{
	char s[1000];
	sprintf(s, "%s %d%s\n", this_polygon_color, this_polygon_no_vertices,
		this_polygon_vertices);
	strcat(polygons, s);
	no_of_polygons++;
}


static void writeAll()
{
	printf("%d %d\n", no_of_points, no_of_polygons);
	printf("%s", points);
	printf("%s", polygons);
}


int main(int argc, char** argv)
{
	int i, j;
	double da;
	VPoint shield[6];
	
	printf("ufo\n");
	
	// The fuselage is a cone with vertex (0,0,-H) and base on the xy plane:
	da = 2 * M_PI / 8;
	for(i = 0; i < 8; i++){
		openPolygon("(gray44 clip)");
		addPoint(&(VPoint){R*cos(i*da+da), R*sin(i*da+da), 0});
		addPoint(&(VPoint) {0, 0, -H});
		addPoint(&(VPoint){R*cos(i*da), R*sin(i*da), 0});
		closePolygon();
	}
	
	// Vertices of an hexagonal shield located along x:
	for(i = 0; i < 6; i++){
		double a = - 2 * M_PI / 6 * i;
		shield[i] = (VPoint) {1.1*R, S*cos(a), S*sin(a)};
	}
	
	// Place 8 shields around the base, right red, left green:
	for(i = 0; i < 8; i++){
		VMatrix m;
		VPoint q;
		VIdentMatrix(&m);
		VRotate(&m, 3, 2*M_PI/16 + i * da);
		openPolygon(i < 4? "(red clip)" : "(green clip)");
		for(j = 0; j < 6; j++){
			VTransform(&shield[j], &m, &q);
			addPoint(&q);
		}
		closePolygon();
	}
	
	writeAll();

	return 0;
}

